/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.cache.disc.impl;

import com.nostra13.dcloudimageloader.cache.disc.BaseDiscCache;
import com.nostra13.dcloudimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.dcloudimageloader.core.DefaultConfigurationFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeDiscCache
extends BaseDiscCache {
    private final long maxFileAge;
    private final Map<File, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeDiscCache(File file, long l2) {
        this(file, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiscCache(File file, FileNameGenerator fileNameGenerator, long l2) {
        super(file, fileNameGenerator);
        this.maxFileAge = l2 * 1000L;
    }

    @Override
    public void put(String string2, File file) {
        long l2 = System.currentTimeMillis();
        file.setLastModified(l2);
        this.loadingDates.put(file, l2);
    }

    @Override
    public File get(String object) {
        if (((File)(object = super.get((String)object))).exists()) {
            Long l2;
            boolean bl;
            Long l3 = this.loadingDates.get(object);
            if (l3 == null) {
                bl = false;
                l2 = ((File)object).lastModified();
            } else {
                boolean bl2;
                bl = bl2 = true;
                l2 = l3;
            }
            if (System.currentTimeMillis() - l2 > this.maxFileAge) {
                ((File)object).delete();
                this.loadingDates.remove(object);
            } else if (!bl) {
                this.loadingDates.put((File)object, l2);
            }
        }
        return object;
    }
}

