/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.PickerConfig;
import com.dmcbig.mediapicker.PreviewActivity;
import com.dmcbig.mediapicker.adapter.FolderAdapter;
import com.dmcbig.mediapicker.adapter.MediaGridAdapter;
import com.dmcbig.mediapicker.adapter.SpacingDecoration;
import com.dmcbig.mediapicker.data.DataCallback;
import com.dmcbig.mediapicker.data.ImageLoader;
import com.dmcbig.mediapicker.data.MediaLoader;
import com.dmcbig.mediapicker.data.VideoLoader;
import com.dmcbig.mediapicker.entity.Folder;
import com.dmcbig.mediapicker.entity.Media;
import com.dmcbig.mediapicker.utils.ScreenUtils;
import io.dcloud.base.R;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.RuningAcitvityUtil;
import io.dcloud.js.gallery.GalleryFeatureImpl;
import java.util.ArrayList;

public class PickerActivity
extends FragmentActivity
implements DataCallback,
View.OnClickListener {
    Intent argsIntent;
    RecyclerView recyclerView;
    Button done;
    Button category_btn;
    Button preview;
    MediaGridAdapter gridAdapter;
    ListPopupWindow mFolderPopupWindow;
    private FolderAdapter mFolderAdapter;
    boolean isSingle = false;
    String doneBtnText = "";

    private void setTopAndBottomBarColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)"#21282C"));
            window.setNavigationBarColor(Color.parseColor((String)"#21282C"));
        }
    }

    private void getOtherArgs() {
        String string2;
        this.doneBtnText = string2 = this.argsIntent.getStringExtra("done_button_text");
        if (!PdrUtil.isEmpty(string2)) {
            ((Button)this.findViewById(R.id.done)).setText((CharSequence)this.doneBtnText);
        }
    }

    protected void onCreate(@Nullable Bundle bundle) {
        PickerActivity pickerActivity = this;
        super.onCreate(bundle);
        pickerActivity.requestWindowFeature(1);
        pickerActivity.argsIntent = pickerActivity.getIntent();
        pickerActivity.setContentView(MediaPickerR.MP_LAYOUT_PICKER_MAIN);
        pickerActivity.recyclerView = (RecyclerView)pickerActivity.findViewById(MediaPickerR.MP_ID_RECYCLER_VIEW);
        pickerActivity.findViewById(MediaPickerR.MP_ID_BTN_BACK).setOnClickListener((View.OnClickListener)this);
        pickerActivity.setTitleBar();
        pickerActivity.done = (Button)pickerActivity.findViewById(MediaPickerR.MP_ID_DONE);
        pickerActivity.category_btn = (Button)pickerActivity.findViewById(MediaPickerR.MP_ID_CATEGORY_BTN);
        pickerActivity.preview = (Button)pickerActivity.findViewById(MediaPickerR.MP_ID_PREVIEW);
        pickerActivity.done.setOnClickListener((View.OnClickListener)this);
        pickerActivity.category_btn.setOnClickListener((View.OnClickListener)this);
        pickerActivity.preview.setOnClickListener((View.OnClickListener)this);
        if (BaseInfo.sGlobalFullScreen) {
            PickerActivity pickerActivity2 = this;
            pickerActivity2.setFullScreen((Activity)pickerActivity2, true);
        }
        PickerActivity pickerActivity3 = this;
        pickerActivity3.createAdapter();
        pickerActivity3.createFolderAdapter();
        pickerActivity3.getMediaData();
        pickerActivity3.getOtherArgs();
        pickerActivity3.setTopAndBottomBarColor();
    }

    public void setTitleBar() {
        int n2 = this.argsIntent.getIntExtra("select_mode", 101);
        if (n2 == 101) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_TITLE));
        } else if (n2 == 100) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_IMAGE_TITLE));
        } else if (n2 == 102) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_VIDEO_TITLE));
        }
    }

    void createAdapter() {
        ArrayList arrayList;
        GridLayoutManager gridLayoutManager;
        PickerActivity pickerActivity = this;
        Object object = gridLayoutManager;
        gridLayoutManager = new GridLayoutManager((Context)this, PickerConfig.GridSpanCount);
        pickerActivity.recyclerView.setLayoutManager((RecyclerView.LayoutManager)object);
        pickerActivity.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpacingDecoration(PickerConfig.GridSpanCount, PickerConfig.GridSpace));
        pickerActivity.recyclerView.setHasFixedSize(true);
        object = arrayList;
        arrayList = new ArrayList();
        ArrayList arrayList2 = pickerActivity.argsIntent.getParcelableArrayListExtra("default_list");
        final String string2 = pickerActivity.argsIntent.getStringExtra("select_max_cb_id");
        int n2 = pickerActivity.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE);
        long l2 = pickerActivity.argsIntent.getLongExtra("max_select_size", Long.MAX_VALUE);
        this.isSingle = pickerActivity.argsIntent.getBooleanExtra("single_select", false);
        if (this.isSingle) {
            Button button = this.done;
            if (button != null) {
                button.setVisibility(8);
            }
            if ((button = this.preview) != null) {
                button.setVisibility(8);
            }
        }
        boolean bl = this.isSingle;
        this.gridAdapter = new MediaGridAdapter((ArrayList<Media>)object, (Context)this, arrayList2, n2, l2, bl);
        this.gridAdapter.setOnMaxListener(new MediaGridAdapter.OnPickerSelectMaxListener(){

            @Override
            public void onMaxed() {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    GalleryFeatureImpl.onMaxed((Context)PickerActivity.this, string2);
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.gridAdapter);
    }

    void createFolderAdapter() {
        ArrayList<Folder> arrayList;
        PickerActivity pickerActivity = this;
        ArrayList<Folder> arrayList2 = arrayList;
        arrayList = new ArrayList<Folder>();
        pickerActivity.mFolderAdapter = new FolderAdapter(arrayList2, (Context)this);
        this.mFolderPopupWindow = new ListPopupWindow((Context)this);
        this.mFolderPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1));
        pickerActivity.mFolderPopupWindow.setAdapter((ListAdapter)this.mFolderAdapter);
        pickerActivity.mFolderPopupWindow.setHeight((int)((double)ScreenUtils.getScreenHeight((Context)this) * 0.6));
        pickerActivity.mFolderPopupWindow.setAnchorView(this.findViewById(MediaPickerR.MP_ID_FOOTER));
        pickerActivity.mFolderPopupWindow.setModal(true);
        pickerActivity.mFolderPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                2 v0 = object;
                v0.PickerActivity.this.mFolderAdapter.setSelectIndex(n2);
                Object object = v0.PickerActivity.this;
                ((PickerActivity)object).category_btn.setText((CharSequence)((PickerActivity)object).mFolderAdapter.getItem((int)n2).name);
                object = v0.PickerActivity.this;
                ((PickerActivity)object).gridAdapter.updateAdapter(((PickerActivity)object).mFolderAdapter.getSelectMedias());
                v0.PickerActivity.this.mFolderPopupWindow.dismiss();
            }
        });
    }

    void getMediaData() {
        int n2 = this.argsIntent.getIntExtra("select_mode", 101);
        if (n2 == 101) {
            MediaLoader mediaLoader;
            MediaLoader mediaLoader2 = mediaLoader;
            PickerActivity pickerActivity = this;
            mediaLoader = new MediaLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)mediaLoader2);
        } else if (n2 == 100) {
            ImageLoader imageLoader;
            ImageLoader imageLoader2 = imageLoader;
            PickerActivity pickerActivity = this;
            imageLoader = new ImageLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)imageLoader2);
        } else if (n2 == 102) {
            VideoLoader videoLoader;
            VideoLoader videoLoader2 = videoLoader;
            PickerActivity pickerActivity = this;
            videoLoader = new VideoLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)videoLoader2);
        }
    }

    @Override
    public void onData(ArrayList<Folder> arrayList) {
        PickerActivity pickerActivity = this;
        pickerActivity.setView(arrayList);
        pickerActivity.category_btn.setText((CharSequence)arrayList.get((int)0).name);
        pickerActivity.mFolderAdapter.updateAdapter(arrayList);
    }

    void setView(ArrayList<Folder> arrayList) {
        PickerActivity pickerActivity = this;
        pickerActivity.gridAdapter.updateAdapter(arrayList.get(0).getMedias());
        pickerActivity.setButtonText();
        pickerActivity.gridAdapter.setOnItemClickListener(new MediaGridAdapter.OnRecyclerViewItemClickListener(){

            @Override
            public void onItemClick(View object, Media media, ArrayList<Media> arrayList) {
                object = PickerActivity.this;
                if (((PickerActivity)object).isSingle) {
                    ArrayList<Integer> arrayList2;
                    ArrayList<Media> arrayList3;
                    Intent intent;
                    object = intent;
                    object((Context)PickerActivity.this, PreviewActivity.class);
                    intent.putExtra("max_select_count", PickerActivity.this.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE));
                    intent.putExtra("single_select", true);
                    arrayList = arrayList3;
                    arrayList(1);
                    arrayList3.add(media);
                    ArrayList<Integer> arrayList4 = arrayList2;
                    arrayList4();
                    arrayList2.add(PickerActivity.this.gridAdapter.getItemIndex(media));
                    intent.putExtra("pre_raw_List", arrayList);
                    intent.putIntegerArrayListExtra("original_preview_index", arrayList4);
                    PickerActivity.this.startActivityForResult((Intent)object, 200);
                } else {
                    ((PickerActivity)object).setButtonText();
                }
            }
        });
    }

    void setButtonText() {
        PickerActivity pickerActivity = this;
        int n2 = pickerActivity.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE);
        if (PdrUtil.isEmpty(pickerActivity.doneBtnText)) {
            this.doneBtnText = this.getString(MediaPickerR.MP_STRING_DONE);
        }
        if (n2 == Integer.MAX_VALUE) {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + this.gridAdapter.getSelectMedias().size() + ")"));
        } else {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + this.gridAdapter.getSelectMedias().size() + "/" + n2 + ")"));
        }
        this.preview.setText((CharSequence)(this.getString(MediaPickerR.MP_STRING_PREVIEW) + "(" + this.gridAdapter.getSelectMedias().size() + ")"));
    }

    public void onClick(View view) {
        ArrayList arrayList2;
        int n2 = view.getId();
        if (n2 == MediaPickerR.MP_ID_BTN_BACK) {
            ArrayList arrayList;
            PickerActivity pickerActivity = arrayList2;
            arrayList2 = arrayList;
            arrayList = new ArrayList();
            pickerActivity.done(arrayList2);
        } else if (n2 == MediaPickerR.MP_ID_CATEGORY_BTN) {
            if (((PickerActivity)((Object)arrayList2)).mFolderPopupWindow.isShowing()) {
                ((PickerActivity)((Object)arrayList2)).mFolderPopupWindow.dismiss();
            } else {
                ((PickerActivity)((Object)arrayList2)).mFolderPopupWindow.show();
            }
        } else if (n2 == MediaPickerR.MP_ID_DONE) {
            Object object = arrayList2;
            ((PickerActivity)object).done(((PickerActivity)object).gridAdapter.getSelectMedias());
        } else if (n2 == MediaPickerR.MP_ID_PREVIEW) {
            ArrayList<Integer> arrayList;
            Intent intent;
            if (((PickerActivity)((Object)arrayList2)).gridAdapter.getSelectMedias().size() <= 0) {
                Object object = arrayList2;
                Toast.makeText((Context)object, (CharSequence)object.getString(MediaPickerR.MP_STRING_SELECT_NULL), (int)0).show();
                return;
            }
            Intent intent2 = intent;
            intent2((Context)arrayList2, PreviewActivity.class);
            intent.putExtra("max_select_count", ((PickerActivity)((Object)arrayList2)).argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE));
            ArrayList<Integer> arrayList3 = ((PickerActivity)((Object)arrayList2)).gridAdapter.getSelectMedias();
            ArrayList<Integer> arrayList5 = arrayList3;
            intent2.putExtra("pre_raw_List", arrayList5);
            arrayList5 = arrayList;
            arrayList = new ArrayList<Integer>();
            for (Media media : arrayList3) {
                arrayList5.add(((PickerActivity)((Object)arrayList2)).gridAdapter.getItemIndex(media));
            }
            Intent intent3 = intent2;
            intent2.putIntegerArrayListExtra("original_preview_index", arrayList5);
            intent2.putExtra("image_editable", ((PickerActivity)((Object)arrayList2)).argsIntent.getBooleanExtra("image_editable", true));
            intent3.putExtra("done_button_text", ((PickerActivity)((Object)arrayList2)).argsIntent.getStringExtra("done_button_text"));
            arrayList2.startActivityForResult(intent3, 200);
        }
    }

    public void done(ArrayList<Media> arrayList) {
        Intent intent;
        PickerActivity pickerActivity = pickerActivity2;
        PickerActivity pickerActivity2 = intent;
        new Intent().putParcelableArrayListExtra("select_result", arrayList);
        pickerActivity.setResult(19901026, (Intent)pickerActivity2);
        pickerActivity.finish();
    }

    protected void onDestroy() {
        PickerActivity pickerActivity = this;
        Glide.get((Context)pickerActivity).clearMemory();
        super.onDestroy();
    }

    public void onBackPressed() {
        ArrayList arrayList;
        PickerActivity pickerActivity = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        pickerActivity.done(arrayList2);
        super.onBackPressed();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    public void onRequestPermissionsResult(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n2, stringArray, nArray);
    }

    protected void onActivityResult(int n2, int n3, Intent object) {
        super.onActivityResult(n2, n3, (Intent)object);
        if (n2 == 200) {
            ArrayList arrayList = object.getParcelableArrayListExtra("select_result");
            if (n3 == 1990) {
                ArrayList arrayList2 = object.getIntegerArrayListExtra("original_preview_index");
                object = object.getParcelableArrayListExtra("edited_preview_data");
                if (arrayList2 != null && arrayList2.size() > 0 && object != null && ((ArrayList)object).size() > 0) {
                    ArrayList<Media> arrayList3 = this.gridAdapter.getMedias();
                    for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                        int n4 = (Integer)arrayList2.get(i2);
                        if (n4 <= 0) continue;
                        arrayList3.set(n4, (Media)((ArrayList)object).get(i2));
                    }
                    this.gridAdapter.updateAdapter(arrayList3);
                }
                PickerActivity pickerActivity = this;
                pickerActivity.gridAdapter.updateSelectAdapter(arrayList);
                pickerActivity.setButtonText();
            } else if (n3 == 19901026) {
                this.done(arrayList);
            }
        }
    }

    public void setFullScreen(Activity activity, boolean bl) {
        PickerActivity pickerActivity = activity.getWindow();
        if (bl) {
            PickerActivity pickerActivity2 = pickerActivity;
            WindowManager.LayoutParams layoutParams = pickerActivity2.getAttributes();
            layoutParams.flags |= 0x400;
            pickerActivity2.setAttributes(layoutParams);
        } else {
            PickerActivity pickerActivity3 = pickerActivity;
            WindowManager.LayoutParams layoutParams = pickerActivity3.getAttributes();
            layoutParams.flags &= 0xFFFFFBFF;
            pickerActivity3.setAttributes(layoutParams);
        }
    }

    protected void onResume() {
        PickerActivity pickerActivity = this;
        super.onResume();
        RuningAcitvityUtil.putRuningActivity((Activity)pickerActivity);
    }

    protected void onPause() {
        PickerActivity pickerActivity = this;
        super.onPause();
        RuningAcitvityUtil.removeRuningActivity(pickerActivity.getComponentName().getClassName());
    }
}

