/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.detector;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.detector.FinderPattern;
import com.dcloud.zxing2.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 57;
    private final BitMatrix image;
    private final List<FinderPattern> possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix bitMatrix) {
        this(bitMatrix, null);
    }

    public FinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        FinderPatternFinder finderPatternFinder = this;
        finderPatternFinder.image = bitMatrix;
        finderPatternFinder.possibleCenters = new ArrayList<FinderPattern>();
        finderPatternFinder.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    private static float centerFromEnd(int[] nArray, int n2) {
        return (float)(n2 - nArray[4] - nArray[3]) - (float)nArray[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] nArray) {
        float f2;
        int n2 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0) {
                return false;
            }
            n2 += n3;
        }
        if (n2 < 7) {
            return false;
        }
        float f3 = (float)n2 / 7.0f;
        float f4 = f3 / 2.0f;
        return Math.abs(f2 - (float)nArray[0]) < f4 && Math.abs(f3 - (float)nArray[1]) < f4 && Math.abs(f3 * 3.0f - (float)nArray[2]) < f4 * 3.0f && Math.abs(f3 - (float)nArray[3]) < f4 && Math.abs(f3 - (float)nArray[4]) < f4;
    }

    private int[] getCrossCheckStateCount() {
        int[] nArray = this.crossCheckStateCount;
        int[] nArray2 = this.crossCheckStateCount;
        nArray[0] = 0;
        nArray2[1] = 0;
        nArray[2] = 0;
        nArray2[3] = 0;
        nArray[4] = 0;
        return nArray2;
    }

    private boolean crossCheckDiagonal(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int[] nArray = this.getCrossCheckStateCount();
        for (n7 = 0; n2 >= n7 && n3 >= n7 && this.image.get(n6 = n3 - n7, n2 - n7); ++n7) {
            nArray[2] = nArray[2] + 1;
        }
        if (n2 >= n7 && n3 >= n7) {
            while (n2 >= n7 && n3 >= n7 && !this.image.get(n6 = n3 - n7, n2 - n7) && nArray[1] <= n4) {
                nArray[1] = nArray[1] + 1;
                ++n7;
            }
            if (n2 >= n7 && n3 >= n7 && nArray[1] <= n4) {
                int n8;
                int n9;
                while (n2 >= n7 && n3 >= n7 && this.image.get(n6 = n3 - n7, n2 - n7) && nArray[0] <= n4) {
                    nArray[0] = nArray[0] + 1;
                    ++n7;
                }
                if (nArray[0] > n4) {
                    return false;
                }
                FinderPatternFinder finderPatternFinder = this;
                n7 = finderPatternFinder.image.getHeight();
                n6 = finderPatternFinder.image.getWidth();
                int n10 = 1;
                while ((n9 = n2 + n10) < n7 && (n8 = n3 + n10) < n6 && this.image.get(n8, n9)) {
                    nArray[2] = nArray[2] + 1;
                    ++n10;
                }
                if (n9 < n7 && n3 + n10 < n6) {
                    while ((n9 = n2 + n10) < n7 && (n8 = n3 + n10) < n6 && !this.image.get(n8, n9) && nArray[3] < n4) {
                        nArray[3] = nArray[3] + 1;
                        ++n10;
                    }
                    if (n9 < n7 && n3 + n10 < n6 && nArray[3] < n4) {
                        while ((n9 = n2 + n10) < n7 && (n8 = n3 + n10) < n6 && this.image.get(n8, n9) && nArray[4] < n4) {
                            nArray[4] = nArray[4] + 1;
                            ++n10;
                        }
                        if (nArray[4] >= n4) {
                            return false;
                        }
                        return Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] - n5) < n5 * 2 && FinderPatternFinder.foundPatternCross(nArray);
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private float crossCheckVertical(int n2, int n3, int n4, int n5) {
        int n6;
        FinderPatternFinder finderPatternFinder = bitMatrix;
        BitMatrix bitMatrix = finderPatternFinder.image;
        int n7 = bitMatrix.getHeight();
        int[] nArray = finderPatternFinder.getCrossCheckStateCount();
        for (n6 = n2; n6 >= 0 && bitMatrix.get(n3, n6); --n6) {
            nArray[2] = nArray[2] + 1;
        }
        if (n6 < 0) {
            return Float.NaN;
        }
        while (n6 >= 0 && !bitMatrix.get(n3, n6) && nArray[1] <= n4) {
            nArray[1] = nArray[1] + 1;
            --n6;
        }
        if (n6 >= 0 && nArray[1] <= n4) {
            while (n6 >= 0 && bitMatrix.get(n3, n6) && nArray[0] <= n4) {
                nArray[0] = nArray[0] + 1;
                --n6;
            }
            if (nArray[0] > n4) {
                return Float.NaN;
            }
            ++n2;
            while (n2 < n7 && bitMatrix.get(n3, n2)) {
                nArray[2] = nArray[2] + 1;
                ++n2;
            }
            if (n2 == n7) {
                return Float.NaN;
            }
            while (n2 < n7 && !bitMatrix.get(n3, n2) && nArray[3] < n4) {
                nArray[3] = nArray[3] + 1;
                ++n2;
            }
            if (n2 != n7 && nArray[3] < n4) {
                while (n2 < n7 && bitMatrix.get(n3, n2) && nArray[4] < n4) {
                    nArray[4] = nArray[4] + 1;
                    ++n2;
                }
                if (nArray[4] >= n4) {
                    return Float.NaN;
                }
                if (Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] - n5) * 5 >= n5 * 2) {
                    return Float.NaN;
                }
                return FinderPatternFinder.foundPatternCross(nArray) ? FinderPatternFinder.centerFromEnd(nArray, n2) : Float.NaN;
            }
            return Float.NaN;
        }
        return Float.NaN;
    }

    private float crossCheckHorizontal(int n2, int n3, int n4, int n5) {
        int n6;
        FinderPatternFinder finderPatternFinder = bitMatrix;
        BitMatrix bitMatrix = finderPatternFinder.image;
        int n7 = bitMatrix.getWidth();
        int[] nArray = finderPatternFinder.getCrossCheckStateCount();
        for (n6 = n2; n6 >= 0 && bitMatrix.get(n6, n3); --n6) {
            nArray[2] = nArray[2] + 1;
        }
        if (n6 < 0) {
            return Float.NaN;
        }
        while (n6 >= 0 && !bitMatrix.get(n6, n3) && nArray[1] <= n4) {
            nArray[1] = nArray[1] + 1;
            --n6;
        }
        if (n6 >= 0 && nArray[1] <= n4) {
            while (n6 >= 0 && bitMatrix.get(n6, n3) && nArray[0] <= n4) {
                nArray[0] = nArray[0] + 1;
                --n6;
            }
            if (nArray[0] > n4) {
                return Float.NaN;
            }
            ++n2;
            while (n2 < n7 && bitMatrix.get(n2, n3)) {
                nArray[2] = nArray[2] + 1;
                ++n2;
            }
            if (n2 == n7) {
                return Float.NaN;
            }
            while (n2 < n7 && !bitMatrix.get(n2, n3) && nArray[3] < n4) {
                nArray[3] = nArray[3] + 1;
                ++n2;
            }
            if (n2 != n7 && nArray[3] < n4) {
                while (n2 < n7 && bitMatrix.get(n2, n3) && nArray[4] < n4) {
                    nArray[4] = nArray[4] + 1;
                    ++n2;
                }
                if (nArray[4] >= n4) {
                    return Float.NaN;
                }
                if (Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] - n5) * 5 >= n5) {
                    return Float.NaN;
                }
                return FinderPatternFinder.foundPatternCross(nArray) ? FinderPatternFinder.centerFromEnd(nArray, n2) : Float.NaN;
            }
            return Float.NaN;
        }
        return Float.NaN;
    }

    private int findRowSkip() {
        if (this.possibleCenters.size() <= 1) {
            return 0;
        }
        FinderPattern finderPattern = null;
        for (FinderPattern finderPattern2 : this.possibleCenters) {
            if (finderPattern2.getCount() >= 2) {
                if (finderPattern != null) {
                    this.hasSkipped = true;
                    return (int)(Math.abs(finderPattern.getX() - finderPattern2.getX()) - Math.abs(finderPattern.getY() - finderPattern2.getY())) / 2;
                }
            } else {
                finderPattern2 = finderPattern;
            }
            finderPattern = finderPattern2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        FinderPatternFinder finderPatternFinder = this;
        int n2 = 0;
        float f2 = 0.0f;
        int n3 = finderPatternFinder.possibleCenters.size();
        for (FinderPattern finderPattern : finderPatternFinder.possibleCenters) {
            if (finderPattern.getCount() < 2) continue;
            ++n2;
            f2 += finderPattern.getEstimatedModuleSize();
        }
        if (n2 < 3) {
            return false;
        }
        float f3 = f2 / (float)n3;
        float f4 = 0.0f;
        Iterator<FinderPattern> iterator = this.possibleCenters.iterator();
        while (iterator.hasNext()) {
            f4 += Math.abs(iterator.next().getEstimatedModuleSize() - f3);
        }
        return f4 <= f2 * 0.05f;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        int n2 = this.possibleCenters.size();
        if (n2 >= 3) {
            if (n2 > 3) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                Iterator<FinderPattern> iterator = this.possibleCenters.iterator();
                while (iterator.hasNext()) {
                    float f4 = iterator.next().getEstimatedModuleSize();
                    f2 += f4;
                    f3 += f4 * f4;
                }
                float f5 = n2;
                float f6 = f2 /= f5;
                f5 = (float)Math.sqrt(f3 / f5 - f6 * f6);
                Collections.sort(this.possibleCenters, new FurthestFromAverageComparator(f2));
                f5 = Math.max(f2 * 0.2f, f5);
                for (int i2 = 0; i2 < this.possibleCenters.size() && this.possibleCenters.size() > 3; ++i2) {
                    if (!(Math.abs(this.possibleCenters.get(i2).getEstimatedModuleSize() - f2) > f5)) continue;
                    this.possibleCenters.remove(i2);
                    --i2;
                }
            }
            if (this.possibleCenters.size() > 3) {
                float f7 = 0.0f;
                Iterator<FinderPattern> iterator = this.possibleCenters.iterator();
                while (iterator.hasNext()) {
                    f7 += iterator.next().getEstimatedModuleSize();
                }
                FinderPatternFinder finderPatternFinder = this;
                Collections.sort(finderPatternFinder.possibleCenters, new CenterComparator(f7 /= (float)this.possibleCenters.size()));
                List<FinderPattern> list = finderPatternFinder.possibleCenters;
                list.subList(3, list.size()).clear();
            }
            FinderPattern[] finderPatternArray = new FinderPattern[3];
            FinderPattern[] finderPatternArray2 = finderPatternArray;
            finderPatternArray2[0] = this.possibleCenters.get(0);
            finderPatternArray2[1] = this.possibleCenters.get(1);
            finderPatternArray[2] = this.possibleCenters.get(2);
            return finderPatternArray;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List<FinderPattern> getPossibleCenters() {
        return this.possibleCenters;
    }

    final FinderPatternInfo find(Map<DecodeHintType, ?> map) throws NotFoundException {
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        int n2 = resultPointArray.image.getHeight();
        int n3 = resultPointArray.image.getWidth();
        int n4 = n2 * 3 / 228;
        if (n4 < 3 || bl) {
            n4 = 3;
        }
        bl = false;
        int[] nArray = new int[5];
        for (int i2 = n4 - 1; i2 < n2 && !bl; i2 += n4) {
            int[] nArray2 = nArray;
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (resultPointArray.image.get(i3, i2)) {
                    if (n5 & true) {
                        ++n5;
                    }
                    nArray[n5] = nArray[n5] + 1;
                    continue;
                }
                if (!(n5 & true)) {
                    if (n5 == 4) {
                        if (FinderPatternFinder.foundPatternCross(nArray)) {
                            if (resultPointArray.handlePossibleCenter(nArray, i2, i3, bl2)) {
                                n4 = 2;
                                if (resultPointArray.hasSkipped) {
                                    bl = super.haveMultiplyConfirmedCenters();
                                } else {
                                    n5 = super.findRowSkip();
                                    if (n5 > nArray[2]) {
                                        i2 += n5 - nArray[2] - n4;
                                        i3 = n3 - 1;
                                    }
                                }
                                int[] nArray3 = nArray;
                                n5 = 0;
                                nArray3[0] = 0;
                                nArray3[1] = 0;
                                nArray3[2] = 0;
                                nArray3[3] = 0;
                                nArray[4] = 0;
                                continue;
                            }
                            int[] nArray4 = nArray;
                            int[] nArray5 = nArray;
                            nArray5[0] = nArray4[2];
                            nArray5[1] = nArray4[3];
                            nArray5[2] = nArray4[4];
                            nArray4[3] = 1;
                            nArray5[4] = 0;
                            n5 = 3;
                            continue;
                        }
                        int[] nArray6 = nArray;
                        int[] nArray7 = nArray;
                        nArray7[0] = nArray6[2];
                        nArray7[1] = nArray6[3];
                        nArray7[2] = nArray6[4];
                        nArray6[3] = 1;
                        nArray7[4] = 0;
                        n5 = 3;
                        continue;
                    }
                    nArray[++n5] = nArray[n5] + 1;
                    continue;
                }
                nArray[n5] = nArray[n5] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(nArray) || !resultPointArray.handlePossibleCenter(nArray, i2, n3, bl2)) continue;
            n4 = nArray[0];
            if (!resultPointArray.hasSkipped) continue;
            bl = super.haveMultiplyConfirmedCenters();
        }
        ResultPoint[] resultPointArray = resultPointArray.selectBestPatterns();
        ResultPoint.orderBestPatterns(resultPointArray);
        return new FinderPatternInfo((FinderPattern[])resultPointArray);
    }

    protected final boolean handlePossibleCenter(int[] nArray, int n2, int n3, boolean bl) {
        int n4;
        float f2;
        int n5 = n2;
        n2 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        float f3 = ((FinderPatternFinder)((Object)finderPattern2)).crossCheckVertical(n5, n3 = (int)FinderPatternFinder.centerFromEnd(nArray, n3), nArray[2], n2);
        if (!(Float.isNaN(f3) || Float.isNaN(f2 = ((FinderPatternFinder)((Object)finderPattern2)).crossCheckHorizontal(n3, n3 = (int)f3, nArray[2], n2)) || bl && !((FinderPatternFinder)((Object)finderPattern2)).crossCheckDiagonal(n3, n4 = (int)f2, nArray[2], n2))) {
            float f4 = (float)n2 / 7.0f;
            n2 = 0;
            for (n3 = 0; n3 < ((FinderPatternFinder)((Object)finderPattern2)).possibleCenters.size(); ++n3) {
                FinderPattern finderPattern = ((FinderPatternFinder)((Object)finderPattern2)).possibleCenters.get(n3);
                if (!finderPattern.aboutEquals(f4, f3, f2)) continue;
                ((FinderPatternFinder)((Object)finderPattern2)).possibleCenters.set(n3, finderPattern.combineEstimate(f3, f2, f4));
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                FinderPattern finderPattern;
                FinderPatternFinder finderPatternFinder = finderPattern2;
                FinderPattern finderPattern2 = finderPattern;
                finderPattern = new FinderPattern(f2, f3, f4);
                finderPatternFinder.possibleCenters.add(finderPattern2);
                ResultPointCallback resultPointCallback = finderPatternFinder.resultPointCallback;
                if (resultPointCallback != null) {
                    resultPointCallback.foundPossibleResultPoint(finderPattern2);
                }
            }
            return true;
        }
        return false;
    }

    private static final class CenterComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private final float average;

        private CenterComparator(float f2) {
            this.average = f2;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            if (finderPattern2.getCount() == finderPattern.getCount()) {
                float f2;
                float f3;
                float f4 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
                float f5 = Math.abs(finderPattern.getEstimatedModuleSize() - this.average);
                return f3 < f2 ? 1 : (f4 == f5 ? 0 : -1);
            }
            return finderPattern2.getCount() - finderPattern.getCount();
        }
    }

    private static final class FurthestFromAverageComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private final float average;

        private FurthestFromAverageComparator(float f2) {
            this.average = f2;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            float f2;
            float f3;
            float f4 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
            float f5 = Math.abs(finderPattern.getEstimatedModuleSize() - this.average);
            return f3 < f2 ? -1 : (f4 == f5 ? 0 : 1);
        }
    }
}

