/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.detector;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.common.GridSampler;
import com.dcloud.zxing2.common.PerspectiveTransform;
import com.dcloud.zxing2.common.detector.MathUtils;
import com.dcloud.zxing2.qrcode.decoder.Version;
import com.dcloud.zxing2.qrcode.detector.AlignmentPattern;
import com.dcloud.zxing2.qrcode.detector.AlignmentPatternFinder;
import com.dcloud.zxing2.qrcode.detector.FinderPattern;
import com.dcloud.zxing2.qrcode.detector.FinderPatternFinder;
import com.dcloud.zxing2.qrcode.detector.FinderPatternInfo;
import java.util.Map;

public class Detector {
    private final BitMatrix image;
    private ResultPointCallback resultPointCallback;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private static PerspectiveTransform createTransform(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2) {
        float f2;
        float f3;
        float f4;
        float f5 = (float)n2 - 3.5f;
        if (resultPoint4 != null) {
            ResultPoint resultPoint5 = resultPoint4;
            f4 = resultPoint5.getX();
            f3 = resultPoint5.getY();
            f2 = f5 - 3.0f;
        } else {
            ResultPoint resultPoint6 = resultPoint2;
            f4 = resultPoint6.getX() - resultPoint.getX() + resultPoint3.getX();
            f3 = resultPoint6.getY() - resultPoint.getY() + resultPoint3.getY();
            f2 = f5;
        }
        ResultPoint resultPoint7 = resultPoint3;
        ResultPoint resultPoint8 = resultPoint2;
        ResultPoint resultPoint9 = resultPoint;
        float f6 = resultPoint9.getX();
        float f7 = resultPoint9.getY();
        float f8 = resultPoint8.getX();
        float f9 = resultPoint8.getY();
        float f10 = resultPoint7.getX();
        float f11 = resultPoint7.getY();
        float f12 = f2;
        return PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, f5, 3.5f, f12, f12, 3.5f, f5, f6, f7, f8, f9, f4, f3, f10, f11);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, PerspectiveTransform perspectiveTransform, int n2) throws NotFoundException {
        int n3 = n2;
        return GridSampler.getInstance().sampleGrid(bitMatrix, n3, n3, perspectiveTransform);
    }

    private static int computeDimension(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, float f2) throws NotFoundException {
        int n2 = (MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2) / f2) + MathUtils.round(ResultPoint.distance(resultPoint, resultPoint3) / f2)) / 2 + 7;
        int n3 = n2 & 3;
        if (n3 != 0) {
            if (n3 != 2) {
                if (n3 == 3) {
                    throw NotFoundException.getNotFoundInstance();
                }
            } else {
                --n2;
            }
        } else {
            ++n2;
        }
        return n2;
    }

    private float calculateModuleSizeOneWay(ResultPoint resultPoint, ResultPoint resultPoint2) {
        ResultPoint resultPoint3 = resultPoint2;
        int n2 = (int)resultPoint.getY();
        int n3 = (int)resultPoint3.getX();
        int n4 = (int)resultPoint3.getY();
        float f2 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint.getX(), n2, n3, n4);
        ResultPoint resultPoint4 = resultPoint;
        int n5 = (int)resultPoint2.getY();
        int n6 = (int)resultPoint4.getX();
        n3 = (int)resultPoint4.getY();
        float f3 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint2.getX(), n5, n6, n3);
        if (Float.isNaN(f2)) {
            return f3 / 7.0f;
        }
        if (Float.isNaN(f3)) {
            return f2 / 7.0f;
        }
        return (f2 + f3) / 14.0f;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int n2, int n3, int n4, int n5) {
        float f2 = this.sizeOfBlackWhiteBlackRun(n2, n3, n4, n5);
        float f3 = 1.0f;
        int n6 = n2 - (n4 - n2);
        if (n6 < 0) {
            f3 = (float)n2 / (float)(n2 - n6);
            n6 = 0;
        } else if (n6 >= this.image.getWidth()) {
            Detector detector = this;
            f3 = (float)(detector.image.getWidth() - 1 - n2) / (float)(n6 - n2);
            n6 = detector.image.getWidth() - 1;
        }
        float f4 = n3;
        n5 = (int)(f4 - (float)(n5 - n3) * f3);
        f3 = 1.0f;
        if (n5 < 0) {
            f3 = f4 / (float)(n3 - n5);
            n5 = 0;
        } else if (n5 >= this.image.getHeight()) {
            Detector detector = this;
            f3 = (float)(detector.image.getHeight() - 1 - n3) / (float)(n5 - n3);
            n5 = detector.image.getHeight() - 1;
        }
        int n7 = n2;
        return f2 + this.sizeOfBlackWhiteBlackRun(n7, n3, (int)((float)n7 + (float)(n6 - n2) * f3), n5) - 1.0f;
    }

    private float sizeOfBlackWhiteBlackRun(int n2, int n3, int n4, int n5) {
        boolean bl = Math.abs(n5 - n3) > Math.abs(n4 - n2);
        if (!bl) {
            int n6 = n4;
            int n7 = n2;
            n2 = n3;
            n4 = n5;
            n3 = n7;
            n5 = n6;
        }
        int n8 = Math.abs(n5 - n3);
        int n9 = Math.abs(n4 - n2);
        int n10 = -n8 / 2;
        int n11 = n3 < n5 ? 1 : -1;
        int n12 = n2 < n4 ? 1 : -1;
        int n13 = n5;
        n5 = 0;
        int n14 = n13 + n11;
        int n15 = n2;
        for (int i2 = n3; i2 != n14; i2 += n11) {
            int n16;
            int n17;
            if (n5 == 1 == this.image.get(n17 = bl ? n15 : i2, n16 = bl ? i2 : n15)) {
                if (n5 == 2) {
                    return MathUtils.distance(i2, n15, n3, n2);
                }
                ++n5;
            }
            if ((n10 += n9) <= 0) continue;
            if (n15 == n4) break;
            n15 += n12;
            n10 -= n8;
        }
        if (n5 == 2) {
            return MathUtils.distance(n14, n4, n3, n2);
        }
        return Float.NaN;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.resultPointCallback;
    }

    public DetectorResult detect() throws NotFoundException, FormatException {
        return this.detect(null);
    }

    public final DetectorResult detect(Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        ResultPointCallback resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        this.resultPointCallback = resultPointCallback;
        return this.processFinderPatternInfo(new FinderPatternFinder(this.image, resultPointCallback).find(map));
    }

    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo object) throws NotFoundException, FormatException {
        FinderPattern finderPattern;
        FinderPattern finderPattern2;
        FinderPatternInfo finderPatternInfo = object;
        object = finderPatternInfo.getTopLeft();
        float f2 = ((Detector)object3).calculateModuleSize((ResultPoint)object, finderPattern2 = finderPatternInfo.getTopRight(), finderPattern = finderPatternInfo.getBottomLeft());
        if (!(f2 < 1.0f)) {
            ResultPoint[] resultPointArray;
            int n2 = Detector.computeDimension((ResultPoint)object, finderPattern2, finderPattern, f2);
            Version version = Version.getProvisionalVersionForDimension(n2);
            int n3 = version.getDimensionForVersion() - 7;
            AlignmentPattern alignmentPattern = null;
            if (version.getAlignmentPatternCenters().length > 0) {
                Object object2 = object;
                FinderPattern finderPattern3 = finderPattern2;
                float f3 = finderPattern3.getX() - ((ResultPoint)object).getX() + finderPattern.getX();
                float f4 = finderPattern3.getY() - ((ResultPoint)object).getY() + finderPattern.getY();
                float f5 = 1.0f - 3.0f / (float)n3;
                int n4 = (int)(((ResultPoint)object2).getX() + f5 * (f3 - ((ResultPoint)object).getX()));
                int n5 = (int)(((ResultPoint)object2).getY() + f5 * (f4 - ((ResultPoint)object).getY()));
                for (int i2 = 4; i2 <= 16; i2 <<= 1) {
                    try {
                        alignmentPattern = ((Detector)object3).findAlignmentInRegion(f2, n4, n5, i2);
                        break;
                    }
                    catch (NotFoundException notFoundException) {
                        continue;
                    }
                }
            }
            Detector detector = object3;
            Object object3 = Detector.createTransform((ResultPoint)object, finderPattern2, finderPattern, alignmentPattern, n2);
            object3 = Detector.sampleGrid(detector.image, (PerspectiveTransform)object3, n2);
            if (alignmentPattern == null) {
                ResultPoint[] resultPointArray2 = new ResultPoint[3];
                resultPointArray = resultPointArray2;
                resultPointArray2[0] = finderPattern;
                resultPointArray2[1] = object;
                resultPointArray2[2] = finderPattern2;
            } else {
                ResultPoint[] resultPointArray3 = new ResultPoint[4];
                resultPointArray = resultPointArray3;
                resultPointArray3[0] = finderPattern;
                resultPointArray3[1] = object;
                resultPointArray3[2] = finderPattern2;
                resultPointArray3[3] = alignmentPattern;
            }
            return new DetectorResult((BitMatrix)object3, resultPointArray);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final float calculateModuleSize(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        return (this.calculateModuleSizeOneWay(resultPoint, resultPoint2) + this.calculateModuleSizeOneWay(resultPoint, resultPoint3)) / 2.0f;
    }

    protected final AlignmentPattern findAlignmentInRegion(float f2, int n2, int n3, float f3) throws NotFoundException {
        float f4;
        int n4 = (int)(f3 * f2);
        int n5 = Math.max(0, n2 - n4);
        n2 = Math.min(((Detector)((Object)bitMatrix)).image.getWidth() - 1, n2 + n4) - n5;
        if (!((float)n2 < (f4 = f2 * 3.0f))) {
            int n6 = Math.max(0, n3 - n4);
            n3 = Math.min(((Detector)((Object)bitMatrix)).image.getHeight() - 1, n3 + n4) - n6;
            if (!((float)n3 < f4)) {
                Detector detector = bitMatrix;
                BitMatrix bitMatrix = detector.image;
                ResultPointCallback resultPointCallback = detector.resultPointCallback;
                return new AlignmentPatternFinder(bitMatrix, n5, n6, n2, n3, f2, resultPointCallback).find();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

