/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.qrcode.decoder.Decoder;
import com.dcloud.zxing2.qrcode.decoder.QRCodeDecoderMetaData;
import com.dcloud.zxing2.qrcode.detector.Detector;
import java.util.Map;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder;

    public QRCodeReader() {
        Decoder decoder;
        Decoder decoder2 = decoder;
        decoder = new Decoder();
        v1.decoder = decoder2;
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray != null && nArray2 != null) {
            float f2 = QRCodeReader.moduleSize(nArray, bitMatrix);
            int n2 = nArray[1];
            int n3 = nArray2[1];
            int n4 = nArray[0];
            int n5 = nArray2[0];
            if (n4 < n5 && n2 < n3) {
                int n6 = n3 - n2;
                if (n6 != n5 - n4) {
                    n5 = n4 + n6;
                }
                int n7 = Math.round((float)(n5 - n4 + 1) / f2);
                n6 = Math.round((float)(n6 + 1) / f2);
                if (n7 > 0 && n6 > 0) {
                    if (n6 == n7) {
                        BitMatrix bitMatrix2;
                        int n8 = n4;
                        int n9 = n2;
                        n2 = (int)(f2 / 2.0f);
                        n4 = n9 + n2;
                        int n10 = n8 + n2;
                        if ((n5 = n10 + (int)((float)(n7 - 1) * f2) - n5) > 0) {
                            if (n5 <= n2) {
                                n10 -= n5;
                            } else {
                                throw NotFoundException.getNotFoundInstance();
                            }
                        }
                        if ((n5 = n4 + (int)((float)(n6 - 1) * f2) - n3) > 0) {
                            if (n5 <= n2) {
                                n4 -= n5;
                            } else {
                                throw NotFoundException.getNotFoundInstance();
                            }
                        }
                        BitMatrix bitMatrix3 = bitMatrix2;
                        bitMatrix2 = new BitMatrix(n7, n6);
                        for (n2 = 0; n2 < n6; ++n2) {
                            n3 = n4 + (int)((float)n2 * f2);
                            for (int i2 = 0; i2 < n7; ++i2) {
                                if (!bitMatrix.get(n10 + (int)((float)i2 * f2), n3)) continue;
                                bitMatrix3.set(i2, n2);
                            }
                        }
                        return bitMatrix3;
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static float moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n2;
        BitMatrix bitMatrix2 = bitMatrix;
        int n3 = bitMatrix2.getHeight();
        int n4 = bitMatrix2.getWidth();
        int n5 = nArray[0];
        boolean bl = true;
        int n6 = 0;
        for (n2 = nArray[1]; n5 < n4 && n2 < n3; ++n5, ++n2) {
            if (bl == bitMatrix.get(n5, n2)) continue;
            if (++n6 == 5) break;
            bl ^= true;
        }
        if (n5 != n4 && n2 != n3) {
            return (float)(n5 - nArray[0]) / 7.0f;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        Result result;
        Object object3;
        if (object2 != null && object2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            QRCodeReader qRCodeReader = object3;
            object3 = QRCodeReader.extractPureBits(object.getBlackMatrix());
            object3 = qRCodeReader.decoder.decode((BitMatrix)object3, (Map<DecodeHintType, ?>)object2);
            object = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(object.getBlackMatrix()).detect((Map<DecodeHintType, ?>)object2);
            object3 = ((QRCodeReader)object3).decoder.decode(detectorResult.getBits(), (Map<DecodeHintType, ?>)object2);
            object = detectorResult.getPoints();
        }
        if (((DecoderResult)object3).getOther() instanceof QRCodeDecoderMetaData) {
            ((QRCodeDecoderMetaData)((DecoderResult)object3).getOther()).applyMirroredCorrection((ResultPoint[])object);
        }
        object2 = result;
        Object object4 = object3;
        Object object5 = ((DecoderResult)object4).getText();
        byte[] byArray = ((DecoderResult)object4).getRawBytes();
        String string2 = object5;
        object5 = BarcodeFormat.QR_CODE;
        ((Result)object2)(string2, byArray, (ResultPoint[])object, (BarcodeFormat)((Object)object5));
        result.textCharset = ((DecoderResult)object3).textCharset;
        object = ((DecoderResult)object3).getByteSegments();
        if (object != null) {
            ((Result)object2).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object);
        }
        if ((object = ((DecoderResult)object3).getECLevel()) != null) {
            ((Result)object2).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object);
        }
        if (((DecoderResult)object3).hasStructuredAppend()) {
            Object object6 = object2;
            ((Result)object6).putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, ((DecoderResult)object3).getStructuredAppendSequenceNumber());
            ((Result)object6).putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, ((DecoderResult)object3).getStructuredAppendParity());
        }
        return object2;
    }

    @Override
    public void reset() {
    }
}

