/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder.ec;

import com.dcloud.zxing2.pdf417.decoder.ec.ModulusPoly;

public final class ModulusGF {
    public static final ModulusGF PDF417_GF = new ModulusGF(929, 3);
    private final int[] expTable;
    private final int[] logTable;
    private final ModulusPoly zero;
    private final ModulusPoly one;
    private final int modulus;

    private ModulusGF(int n2, int n3) {
        ModulusPoly modulusPoly;
        ModulusPoly modulusPoly2;
        this.modulus = n2;
        this.expTable = new int[n2];
        this.logTable = new int[n2];
        int n4 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.expTable[i2] = n4;
            n4 = n4 * n3 % n2;
        }
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            this.logTable[this.expTable[n3]] = n3;
        }
        ModulusGF modulusGF = this;
        ModulusPoly modulusPoly3 = modulusPoly2;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        modulusPoly2 = new ModulusPoly(this, nArray2);
        modulusGF.zero = modulusPoly3;
        modulusPoly3 = modulusPoly;
        int[] nArray3 = new int[1];
        nArray2 = nArray3;
        nArray3[0] = 1;
        modulusPoly = new ModulusPoly(this, nArray2);
        modulusGF.one = modulusPoly3;
    }

    ModulusPoly getZero() {
        return this.zero;
    }

    ModulusPoly getOne() {
        return this.one;
    }

    ModulusPoly buildMonomial(int n2, int n3) {
        if (n2 >= 0) {
            if (n3 == 0) {
                return this.zero;
            }
            int[] nArray = new int[n2 + 1];
            int[] nArray2 = nArray;
            nArray[0] = n3;
            return new ModulusPoly(this, nArray2);
        }
        throw new IllegalArgumentException();
    }

    int add(int n2, int n3) {
        return (n2 + n3) % this.modulus;
    }

    int subtract(int n2, int n3) {
        int n4 = this.modulus;
        return (n4 + n2 - n3) % n4;
    }

    int exp(int n2) {
        return this.expTable[n2];
    }

    int log(int n2) {
        if (n2 != 0) {
            return this.logTable[n2];
        }
        throw new IllegalArgumentException();
    }

    int inverse(int n2) {
        if (n2 != 0) {
            return this.expTable[this.modulus - this.logTable[n2] - 1];
        }
        throw new ArithmeticException();
    }

    int multiply(int n2, int n3) {
        if (n2 != 0 && n3 != 0) {
            int[] nArray = this.logTable;
            return this.expTable[(this.logTable[n2] + nArray[n3]) % (this.modulus - 1)];
        }
        return 0;
    }

    int getSize() {
        return this.modulus;
    }
}

