/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.pdf417.decoder.BarcodeMetadata;
import com.dcloud.zxing2.pdf417.decoder.BarcodeValue;
import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultColumn;

final class DetectionResultRowIndicatorColumn
extends DetectionResultColumn {
    private final boolean isLeft;

    DetectionResultRowIndicatorColumn(BoundingBox boundingBox, boolean bl) {
        super(boundingBox);
        this.isLeft = bl;
    }

    private void removeIncorrectCodewords(Codeword[] codewordArray, BarcodeMetadata barcodeMetadata) {
        for (int i2 = 0; i2 < codewordArray.length; ++i2) {
            Codeword codeword = codewordArray[i2];
            if (codewordArray[i2] == null) continue;
            Codeword codeword2 = codeword;
            int n2 = codeword2.getValue() % 30;
            int n3 = codeword2.getRowNumber();
            if (n3 > barcodeMetadata.getRowCount()) {
                codewordArray[i2] = null;
                continue;
            }
            if (!this.isLeft) {
                n3 += 2;
            }
            if ((n3 %= 3) != 0) {
                if (n3 != 1) {
                    if (n3 != 2 || n2 + 1 == barcodeMetadata.getColumnCount()) continue;
                    codewordArray[i2] = null;
                    continue;
                }
                if (n2 / 3 == barcodeMetadata.getErrorCorrectionLevel() && n2 % 3 == barcodeMetadata.getRowCountLowerPart()) continue;
                codewordArray[i2] = null;
                continue;
            }
            if (n2 * 3 + 1 == barcodeMetadata.getRowCountUpperPart()) continue;
            codewordArray[i2] = null;
        }
    }

    void setRowNumbers() {
        for (Codeword codeword : this.getCodewords()) {
            if (codeword == null) continue;
            codeword.setRowNumberAsRowIndicatorColumn();
        }
    }

    int adjustCompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        int n2;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = this;
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        detectionResultRowIndicatorColumn.setRowNumbers();
        detectionResultRowIndicatorColumn.removeIncorrectCodewords(codewordArray, barcodeMetadata);
        Object object = detectionResultRowIndicatorColumn.getBoundingBox();
        ResultPoint resultPoint = detectionResultRowIndicatorColumn.isLeft ? ((BoundingBox)object).getTopLeft() : ((BoundingBox)object).getTopRight();
        object = this.isLeft ? ((BoundingBox)object).getBottomLeft() : ((BoundingBox)object).getBottomRight();
        int n3 = this.imageRowToCodewordIndex((int)((ResultPoint)object).getY());
        float f2 = (float)(n3 - n2) / (float)barcodeMetadata.getRowCount();
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        for (n2 = this.imageRowToCodewordIndex((int)resultPoint.getY()); n2 < n3; ++n2) {
            if (codewordArray[n2] == null) continue;
            Codeword codeword = codewordArray[n2];
            int n7 = codeword.getRowNumber() - n4;
            if (n7 == 0) {
                ++n6;
                continue;
            }
            if (n7 == 1) {
                n5 = Math.max(n5, n6);
                n6 = 1;
                n4 = codeword.getRowNumber();
                continue;
            }
            if (n7 >= 0 && codeword.getRowNumber() < barcodeMetadata.getRowCount() && n7 <= n2) {
                if (n5 > 2) {
                    n7 = (n5 - 2) * n7;
                }
                boolean bl = n7 >= n2;
                for (int i2 = 1; i2 <= n7 && !bl; ++i2) {
                    bl = codewordArray[n2 - i2] != null;
                }
                if (bl) {
                    codewordArray[n2] = null;
                    continue;
                }
                n4 = codeword.getRowNumber();
                n6 = 1;
                continue;
            }
            codewordArray[n2] = null;
        }
        return (int)((double)f2 + 0.5);
    }

    int[] getRowHeights() throws FormatException {
        Object object = this.getBarcodeMetadata();
        if (object == null) {
            return null;
        }
        this.adjustIncompleteIndicatorColumnRowNumbers((BarcodeMetadata)object);
        int n2 = ((BarcodeMetadata)object).getRowCount();
        object = new int[n2];
        for (Codeword codeword : this.getCodewords()) {
            int n3;
            if (codeword == null || (n3 = codeword.getRowNumber()) >= n2) continue;
            object[n3] = object[n3] + true;
        }
        return object;
    }

    int adjustIncompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        int n2;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = this;
        Object object = detectionResultRowIndicatorColumn.getBoundingBox();
        ResultPoint resultPoint = detectionResultRowIndicatorColumn.isLeft ? ((BoundingBox)object).getTopLeft() : ((BoundingBox)object).getTopRight();
        object = this.isLeft ? ((BoundingBox)object).getBottomLeft() : ((BoundingBox)object).getBottomRight();
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2 = this;
        int n3 = detectionResultRowIndicatorColumn2.imageRowToCodewordIndex((int)((ResultPoint)object).getY());
        float f2 = (float)(n3 - n2) / (float)barcodeMetadata.getRowCount();
        Codeword[] codewordArray = detectionResultRowIndicatorColumn2.getCodewords();
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        for (n2 = this.imageRowToCodewordIndex((int)resultPoint.getY()); n2 < n3; ++n2) {
            if (codewordArray[n2] == null) continue;
            Codeword codeword = codewordArray[n2];
            codeword.setRowNumberAsRowIndicatorColumn();
            int n7 = codeword.getRowNumber() - n4;
            if (n7 == 0) {
                ++n6;
                continue;
            }
            if (n7 == 1) {
                n5 = Math.max(n5, n6);
                n6 = 1;
                n4 = codeword.getRowNumber();
                continue;
            }
            if (codeword.getRowNumber() >= barcodeMetadata.getRowCount()) {
                codewordArray[n2] = null;
                continue;
            }
            n4 = codeword.getRowNumber();
            n6 = 1;
        }
        return (int)((double)f2 + 0.5);
    }

    BarcodeMetadata getBarcodeMetadata() {
        BarcodeValue barcodeValue;
        BarcodeValue barcodeValue2;
        BarcodeValue barcodeValue3;
        BarcodeValue barcodeValue4;
        Codeword[] codewordArray = this.getCodewords();
        BarcodeValue barcodeValue5 = barcodeValue4;
        barcodeValue4 = new BarcodeValue();
        BarcodeValue barcodeValue6 = barcodeValue3;
        barcodeValue3 = new BarcodeValue();
        BarcodeValue barcodeValue7 = barcodeValue2;
        barcodeValue2 = new BarcodeValue();
        BarcodeValue barcodeValue8 = barcodeValue;
        barcodeValue = new BarcodeValue();
        int n2 = codewordArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Codeword codeword = codewordArray[i2];
            if (codeword == null) continue;
            Codeword codeword2 = codeword;
            codeword2.setRowNumberAsRowIndicatorColumn();
            int n3 = codeword2.getValue() % 30;
            int n4 = codeword2.getRowNumber();
            if (!this.isLeft) {
                n4 += 2;
            }
            if ((n4 %= 3) != 0) {
                if (n4 != 1) {
                    if (n4 != 2) continue;
                    barcodeValue5.setValue(n3 + 1);
                    continue;
                }
                barcodeValue8.setValue(n3 / 3);
                barcodeValue7.setValue(n3 % 3);
                continue;
            }
            barcodeValue6.setValue(n3 * 3 + 1);
        }
        if (barcodeValue5.getValue().length != 0 && barcodeValue6.getValue().length != 0 && barcodeValue7.getValue().length != 0 && barcodeValue8.getValue().length != 0 && barcodeValue5.getValue()[0] >= 1 && barcodeValue6.getValue()[0] + barcodeValue7.getValue()[0] >= 3 && barcodeValue6.getValue()[0] + barcodeValue7.getValue()[0] <= 90) {
            BarcodeMetadata barcodeMetadata;
            BarcodeMetadata barcodeMetadata2;
            BarcodeMetadata barcodeMetadata3 = barcodeMetadata2 = barcodeMetadata;
            int n5 = barcodeValue6.getValue()[0];
            int n6 = barcodeValue7.getValue()[0];
            int n7 = barcodeValue8.getValue()[0];
            barcodeMetadata3(barcodeValue5.getValue()[0], n5, n6, n7);
            this.removeIncorrectCodewords(codewordArray, barcodeMetadata3);
            return barcodeMetadata;
        }
        return null;
    }

    boolean isLeft() {
        return this.isLeft;
    }

    @Override
    public String toString() {
        return "IsLeft: " + this.isLeft + '\n' + super.toString();
    }
}

