/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;

final class BoundingBox {
    private BitMatrix image;
    private ResultPoint topLeft;
    private ResultPoint bottomLeft;
    private ResultPoint topRight;
    private ResultPoint bottomRight;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    BoundingBox(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        if (resultPoint == null && resultPoint3 == null || resultPoint2 == null && resultPoint4 == null || resultPoint != null && resultPoint2 == null || resultPoint3 != null && resultPoint4 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.init(bitMatrix, resultPoint, resultPoint2, resultPoint3, resultPoint4);
    }

    BoundingBox(BoundingBox object) {
        BoundingBox boundingBox = bitMatrix;
        BoundingBox boundingBox2 = object;
        BitMatrix bitMatrix = boundingBox2.image;
        object = boundingBox2.topLeft;
        ResultPoint resultPoint = boundingBox2.bottomLeft;
        ResultPoint resultPoint2 = boundingBox2.topRight;
        ResultPoint resultPoint3 = boundingBox2.bottomRight;
        boundingBox.init(bitMatrix, (ResultPoint)object, resultPoint, resultPoint2, resultPoint3);
    }

    private void init(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        this.image = bitMatrix;
        this.topLeft = resultPoint;
        this.bottomLeft = resultPoint2;
        this.topRight = resultPoint3;
        this.bottomRight = resultPoint4;
        this.calculateMinMaxValues();
    }

    static BoundingBox merge(BoundingBox object, BoundingBox object2) throws NotFoundException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        BoundingBox boundingBox = object2;
        BoundingBox boundingBox2 = object;
        object = boundingBox2.image;
        object2 = boundingBox2.topLeft;
        ResultPoint resultPoint = boundingBox2.bottomLeft;
        ResultPoint resultPoint2 = boundingBox.topRight;
        ResultPoint resultPoint3 = boundingBox.bottomRight;
        return new BoundingBox((BitMatrix)object, (ResultPoint)object2, resultPoint, resultPoint2, resultPoint3);
    }

    private void calculateMinMaxValues() {
        if (this.topLeft == null) {
            BoundingBox boundingBox = this;
            boundingBox.topLeft = new ResultPoint(0.0f, this.topRight.getY());
            boundingBox.bottomLeft = new ResultPoint(0.0f, this.bottomRight.getY());
        } else if (this.topRight == null) {
            BoundingBox boundingBox = this;
            boundingBox.topRight = new ResultPoint(this.image.getWidth() - 1, this.topLeft.getY());
            boundingBox.bottomRight = new ResultPoint(this.image.getWidth() - 1, this.bottomLeft.getY());
        }
        BoundingBox boundingBox = this;
        boundingBox.minX = (int)Math.min(boundingBox.topLeft.getX(), this.bottomLeft.getX());
        boundingBox.maxX = (int)Math.max(boundingBox.topRight.getX(), this.bottomRight.getX());
        boundingBox.minY = (int)Math.min(boundingBox.topLeft.getY(), this.topRight.getY());
        boundingBox.maxY = (int)Math.max(boundingBox.bottomLeft.getY(), this.bottomRight.getY());
    }

    BoundingBox addMissingRows(int n2, int n3, boolean bl) throws NotFoundException {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        BoundingBox boundingBox = this;
        ResultPoint resultPoint5 = boundingBox.topLeft;
        ResultPoint resultPoint6 = boundingBox.bottomLeft;
        ResultPoint resultPoint7 = boundingBox.topRight;
        ResultPoint resultPoint8 = boundingBox.bottomRight;
        if (n2 > 0) {
            ResultPoint resultPoint9;
            ResultPoint resultPoint10 = bl ? resultPoint5 : resultPoint7;
            n2 = (int)resultPoint10.getY() - n2;
            if (n2 < 0) {
                n2 = 0;
            }
            resultPoint4 = resultPoint9;
            float f2 = resultPoint10.getX();
            resultPoint9 = new ResultPoint(f2, n2);
            if (bl) {
                resultPoint3 = resultPoint7;
            } else {
                resultPoint3 = resultPoint4;
                resultPoint4 = resultPoint5;
            }
        } else {
            resultPoint3 = resultPoint7;
            resultPoint4 = resultPoint5;
        }
        if (n3 > 0) {
            ResultPoint resultPoint11;
            resultPoint5 = bl ? this.bottomLeft : this.bottomRight;
            n3 = (int)resultPoint5.getY() + n3;
            if (n3 >= this.image.getHeight()) {
                n3 = this.image.getHeight() - 1;
            }
            resultPoint2 = resultPoint11;
            float f3 = resultPoint5.getX();
            resultPoint11 = new ResultPoint(f3, n3);
            if (bl) {
                resultPoint = resultPoint8;
            } else {
                resultPoint = resultPoint2;
                resultPoint2 = resultPoint6;
            }
        } else {
            resultPoint = resultPoint8;
            resultPoint2 = resultPoint6;
        }
        this.calculateMinMaxValues();
        return new BoundingBox(this.image, resultPoint4, resultPoint2, resultPoint3, resultPoint);
    }

    int getMinX() {
        return this.minX;
    }

    int getMaxX() {
        return this.maxX;
    }

    int getMinY() {
        return this.minY;
    }

    int getMaxY() {
        return this.maxY;
    }

    ResultPoint getTopLeft() {
        return this.topLeft;
    }

    ResultPoint getTopRight() {
        return this.topRight;
    }

    ResultPoint getBottomLeft() {
        return this.bottomLeft;
    }

    ResultPoint getBottomRight() {
        return this.bottomRight;
    }
}

