/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.pdf417.encoder.Compaction;
import com.dcloud.zxing2.pdf417.encoder.Dimensions;
import com.dcloud.zxing2.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    static final int WHITE_SPACE = 30;
    static final int DEFAULT_ERROR_CORRECTION_LEVEL = 2;

    private static BitMatrix bitMatrixFromEncoder(PDF417 object, String string2, int n2, int n3, int n4, int n5) throws WriterException {
        PDF417 pDF417 = object;
        pDF417.generateBarcodeLogic(string2, n2);
        int n6 = 4;
        byte[][] byArray = pDF417.getBarcodeMatrix().getScaledMatrix(1, n6);
        boolean bl = false;
        boolean bl2 = n4 > n3;
        boolean bl3 = byArray[0].length < byArray.length;
        if (bl2 ^ bl3) {
            byArray = PDF417Writer.rotateArray(byArray);
            bl = true;
        }
        if ((n3 /= byArray[0].length) < (n4 /= byArray.length)) {
            n4 = n3;
        }
        if (n4 > 1) {
            int n7 = n4;
            object = ((PDF417)object).getBarcodeMatrix().getScaledMatrix(n7, n7 * n6);
            if (bl) {
                object = PDF417Writer.rotateArray((byte[][])object);
            }
            return PDF417Writer.bitMatrixFrombitArray((byte[][])object, n5);
        }
        return PDF417Writer.bitMatrixFrombitArray(byArray, n5);
    }

    private static BitMatrix bitMatrixFrombitArray(byte[][] byArray, int n2) {
        BitMatrix bitMatrix;
        BitMatrix bitMatrix2 = bitMatrix;
        int n3 = n2 * 2;
        new BitMatrix(byArray[0].length + n3, byArray.length + n3).clear();
        n3 = 0;
        int n4 = bitMatrix2.getHeight() - n2 - 1;
        while (n3 < byArray.length) {
            for (int i2 = 0; i2 < byArray[0].length; ++i2) {
                if (byArray[n3][i2] != 1) continue;
                bitMatrix2.set(i2 + n2, n4);
            }
            ++n3;
            --n4;
        }
        return bitMatrix2;
    }

    private static byte[][] rotateArray(byte[][] byArray) {
        byte[][] byArray2 = new byte[byArray[0].length][byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray.length - i2 - 1;
            for (int i3 = 0; i3 < byArray[0].length; ++i3) {
                byArray2[i3][n2] = byArray[i2][i3];
            }
        }
        return byArray2;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.PDF_417) {
            PDF417 pDF417;
            PDF417 pDF4172 = pDF417;
            pDF417 = new PDF417();
            int n4 = 30;
            int n5 = 2;
            if (map != null) {
                EncodeHintType encodeHintType;
                EncodeHintType encodeHintType2 = EncodeHintType.PDF417_COMPACT;
                if (map.containsKey((Object)encodeHintType2)) {
                    pDF4172.setCompact(Boolean.valueOf(map.get((Object)encodeHintType2).toString()));
                }
                if (map.containsKey((Object)(encodeHintType2 = EncodeHintType.PDF417_COMPACTION))) {
                    pDF4172.setCompaction(Compaction.valueOf(map.get((Object)encodeHintType2).toString()));
                }
                if (map.containsKey((Object)(encodeHintType2 = EncodeHintType.PDF417_DIMENSIONS))) {
                    Dimensions dimensions = (Dimensions)map.get((Object)encodeHintType2);
                    int n6 = dimensions.getMaxCols();
                    int n7 = dimensions.getMinCols();
                    int n8 = dimensions.getMaxRows();
                    int n9 = dimensions.getMinRows();
                    pDF4172.setDimensions(n6, n7, n8, n9);
                }
                if (map.containsKey((Object)(encodeHintType = EncodeHintType.MARGIN))) {
                    n4 = Integer.parseInt(map.get((Object)encodeHintType).toString());
                }
                if (map.containsKey((Object)(encodeHintType = EncodeHintType.ERROR_CORRECTION))) {
                    n5 = Integer.parseInt(map.get((Object)encodeHintType).toString());
                }
                if (map.containsKey((Object)(encodeHintType = EncodeHintType.CHARACTER_SET))) {
                    pDF4172.setEncoding(Charset.forName(map.get((Object)encodeHintType).toString()));
                }
            }
            return PDF417Writer.bitMatrixFromEncoder(pDF4172, string2, n5, n2, n3, n4);
        }
        throw new IllegalArgumentException("Can only encode PDF_417, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }
}

