/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    private static int extensionChecksum(CharSequence charSequence) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i2 = n2 - 2; i2 >= 0; i2 -= 2) {
            n3 += charSequence.charAt(i2) - 48;
        }
        int n4 = n2;
        n2 = n3 * 3;
        for (n3 = (v114697) - 1; n3 >= 0; n3 -= 2) {
            n2 += charSequence.charAt(n3) - 48;
        }
        return n2 * 3 % 10;
    }

    private static int determineCheckDigit(int n2) throws NotFoundException {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (n2 != CHECK_DIGIT_ENCODINGS[i2]) continue;
            return i2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String string2) {
        if (string2.length() != 5) {
            return null;
        }
        if ((string2 = UPCEANExtension5Support.parseExtension5String(string2)) == null) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> enumMap = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.SUGGESTED_PRICE, string2);
        return enumMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parseExtension5String(String string2) {
        String string3;
        String string4;
        char c2 = string2.charAt(0);
        if (c2 != '0') {
            if (c2 != '5') {
                if (c2 == '9') {
                    if ("90000".equals(string2)) {
                        return null;
                    }
                    if ("99991".equals(string2)) {
                        return "0.00";
                    }
                    if ("99990".equals(string2)) {
                        return "Used";
                    }
                }
                string4 = "";
            } else {
                string4 = "$";
            }
        } else {
            string4 = "\u00a3";
        }
        int n2 = Integer.parseInt(string2.substring(1));
        string2 = String.valueOf(n2 / 100);
        int n3 = n2 % 100;
        if (n3 < 10) {
            string3 = "0" + n3;
            return string4 + string2 + '.' + string3;
        }
        string3 = String.valueOf(n3);
        return string4 + string2 + '.' + string3;
    }

    Result decodeRow(int n2, BitArray resultPointArray, int[] nArray) throws NotFoundException {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        Result result;
        Object object = this.decodeRowStringBuffer;
        ((StringBuilder)object).setLength(0);
        int n3 = this.decodeMiddle((BitArray)resultPointArray, nArray, (StringBuilder)object);
        resultPointArray = ((StringBuilder)object).toString();
        object = UPCEANExtension5Support.parseExtensionString((String)resultPointArray);
        Result result2 = result;
        ResultPoint[] resultPointArray2 = resultPointArray;
        ResultPoint[] resultPointArray3 = new ResultPoint[2];
        resultPointArray = resultPointArray3;
        ResultPoint resultPoint3 = resultPoint2;
        float f2 = (float)(nArray[0] + nArray[1]) / 2.0f;
        float f3 = n2;
        resultPoint2 = new ResultPoint(f2, f3);
        resultPointArray3[0] = resultPoint3;
        ResultPoint resultPoint4 = resultPoint;
        resultPoint = new ResultPoint(n3, f3);
        resultPointArray3[1] = resultPoint4;
        BarcodeFormat barcodeFormat = BarcodeFormat.UPC_EAN_EXTENSION;
        result = new Result((String)resultPointArray2, null, resultPointArray, barcodeFormat);
        if (object != null) {
            result2.putAllMetadata((Map<ResultMetadataType, Object>)object);
        }
        return result2;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray2 = ((UPCEANExtension5Support)object).decodeMiddleCounters;
        Object object = nArray2;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        ((UPCEANExtension5Support)object).decodeMiddleCounters[3] = 0;
        int n2 = bitArray.getSize();
        int n3 = nArray[1];
        int n4 = 0;
        for (int i2 = 0; i2 < 5 && n3 < n2; ++i2) {
            int n5 = UPCEANReader.decodeDigit(bitArray, (int[])object, n3, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(n5 % 10 + 48));
            int n6 = ((Object)object).length;
            for (int i3 = 0; i3 < n6; ++i3) {
                n3 += object[i3];
            }
            if (n5 >= 10) {
                n4 |= 1 << 4 - i2;
            }
            if (i2 == 4) continue;
            BitArray bitArray2 = bitArray;
            n3 = bitArray2.getNextUnset(bitArray2.getNextSet(n3));
        }
        if (stringBuilder.length() == 5) {
            int n7 = UPCEANExtension5Support.determineCheckDigit(n4);
            if (UPCEANExtension5Support.extensionChecksum(stringBuilder.toString()) == n7) {
                return n3;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

