/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import java.util.Map;

public abstract class OneDimensionalCodeWriter
implements Writer {
    private static BitMatrix renderResult(boolean[] blArray, int n2, int n3, int n4) {
        BitMatrix bitMatrix;
        int n5 = n2;
        n2 = blArray.length;
        n4 = n2 + n4;
        int n6 = Math.max(n5, n4);
        n3 = Math.max(1, n3);
        n4 = n6 / n4;
        int n7 = (n6 - n2 * n4) / 2;
        BitMatrix bitMatrix2 = bitMatrix;
        bitMatrix = new BitMatrix(n6, n3);
        n6 = 0;
        while (n6 < n2) {
            if (blArray[n6]) {
                bitMatrix2.setRegion(n7, 0, n4, n3);
            }
            ++n6;
            n7 += n4;
        }
        return bitMatrix2;
    }

    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean bl) {
        int n3 = 0;
        for (int n4 : nArray) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + 1;
                blArray[n2] = bl;
                n2 = n5;
            }
            n3 += n4;
            bl ^= true;
        }
        return n3;
    }

    @Override
    public final BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (!string2.isEmpty()) {
            if (n2 >= 0 && n3 >= 0) {
                EncodeHintType encodeHintType;
                int n4 = this.getDefaultMargin();
                if (map != null && map.containsKey((Object)(encodeHintType = EncodeHintType.MARGIN))) {
                    n4 = Integer.parseInt(map.get((Object)encodeHintType).toString());
                }
                return OneDimensionalCodeWriter.renderResult(this.encode(string2), n2, n3, n4);
            }
            throw new IllegalArgumentException("Negative size is not allowed. Input: " + n2 + 'x' + n3);
        }
        throw new IllegalArgumentException("Found empty contents");
    }

    public int getDefaultMargin() {
        return 10;
    }

    public abstract boolean[] encode(String var1);
}

