/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code93Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{276, 328, 324, 322, 296, 292, 290, 336, 274, 266, 424, 420, 418, 404, 402, 394, 360, 356, 354, 308, 282, 344, 332, 326, 300, 278, 436, 434, 428, 422, 406, 410, 364, 358, 310, 314, 302, 468, 466, 458, 366, 374, 430, 294, 474, 470, 306, 350};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[47];
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private final int[] counters = new int[6];

    private int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n2;
        Code93Reader code93Reader = this;
        int n3 = bitArray.getSize();
        Arrays.fill(code93Reader.counters, 0);
        int[] nArray = code93Reader.counters;
        int n4 = 0;
        int n5 = code93Reader.counters.length;
        int n6 = 0;
        int n7 = n4;
        n4 = n2;
        int n8 = n6;
        n6 = n7;
        for (n2 = (v630881).getNextSet(0); n2 < n3; ++n2) {
            if ((bitArray.get(n2) ^ n6) != 0) {
                nArray[n8] = nArray[n8] + 1;
                continue;
            }
            int n9 = n5 - 1;
            if (n8 == n9) {
                if (Code93Reader.toPattern(nArray) == ASTERISK_ENCODING) {
                    return new int[]{n4, n2};
                }
                int n10 = n9;
                n4 += nArray[0] + nArray[1];
                n9 = n5 - 2;
                System.arraycopy(nArray, 2, nArray, 0, n9);
                nArray[n9] = 0;
                nArray[n10] = 0;
                --n8;
            } else {
                ++n8;
            }
            nArray[n8] = 1;
            n6 ^= 1;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toPattern(int[] nArray) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = nArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n4 += nArray[n2];
        }
        n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = Math.round((float)nArray[n2] * 9.0f / (float)n4);
            if (n6 >= 1 && n6 <= 4) {
                if ((n2 & 1) == 0) {
                    for (int i2 = 0; i2 < n6; ++i2) {
                        n5 = n5 << 1 | 1;
                    }
                    continue;
                }
                n5 <<= n6;
                continue;
            }
            return -1;
        }
        return n5;
    }

    private static char patternToChar(int n2) throws NotFoundException {
        int n3 = 0;
        while (true) {
            int[] nArray = CHARACTER_ENCODINGS;
            if (n3 >= CHARACTER_ENCODINGS.length) break;
            if (nArray[n3] == n2) {
                return ALPHABET[n3];
            }
            ++n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        StringBuilder stringBuilder;
        int n2 = charSequence.length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= 'a' && c2 <= 'd') {
                if (i2 < n2 - 1) {
                    char c3 = c2;
                    c2 = charSequence.charAt(++i2);
                    int n3 = 0;
                    switch (c3) {
                        default: {
                            break;
                        }
                        case 'd': {
                            if (c2 >= 'A' && c2 <= 'Z') {
                                n3 = (char)(c2 + 32);
                                break;
                            }
                            throw FormatException.getFormatInstance();
                        }
                        case 'c': {
                            if (c2 >= 'A' && c2 <= 'O') {
                                n3 = (char)(c2 - 32);
                                break;
                            }
                            if (c2 == 'Z') {
                                n3 = 58;
                                break;
                            }
                            throw FormatException.getFormatInstance();
                        }
                        case 'b': {
                            if (c2 >= 'A' && c2 <= 'E') {
                                n3 = (char)(c2 - 38);
                                break;
                            }
                            if (c2 >= 'F' && c2 <= 'J') {
                                n3 = (char)(c2 - 11);
                                break;
                            }
                            if (c2 >= 'K' && c2 <= 'O') {
                                n3 = (char)(c2 + 16);
                                break;
                            }
                            if (c2 >= 'P' && c2 <= 'S') {
                                n3 = (char)(c2 + 43);
                                break;
                            }
                            if (c2 >= 'T' && c2 <= 'Z') {
                                n3 = 127;
                                break;
                            }
                            throw FormatException.getFormatInstance();
                        }
                        case 'a': {
                            if (c2 >= 'A' && c2 <= 'Z') {
                                n3 = (char)(c2 - 64);
                                break;
                            }
                            throw FormatException.getFormatInstance();
                        }
                    }
                    stringBuilder2.append((char)n3);
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            stringBuilder2.append(c2);
        }
        return stringBuilder2.toString();
    }

    private static void checkChecksums(CharSequence charSequence) throws ChecksumException {
        CharSequence charSequence2 = charSequence;
        int n2 = charSequence2.length();
        Code93Reader.checkOneChecksum(charSequence, n2 - 2, 20);
        Code93Reader.checkOneChecksum(charSequence2, n2 - 1, 15);
    }

    private static void checkOneChecksum(CharSequence charSequence, int n2, int n3) throws ChecksumException {
        int n4 = 1;
        int n5 = 0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            n5 += n4 * ALPHABET_STRING.indexOf(charSequence.charAt(i2));
            if (++n4 <= n3) continue;
            n4 = 1;
        }
        if (charSequence.charAt(n2) == ALPHABET[n5 % 47]) {
            return;
        }
        throw ChecksumException.getChecksumInstance();
    }

    @Override
    public Result decodeRow(int n2, BitArray resultPointArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        Code93Reader code93Reader = object;
        BitArray bitArray = resultPointArray;
        int[] nArray = ((Code93Reader)object).findAsteriskPattern((BitArray)resultPointArray);
        Object object = nArray;
        int n3 = bitArray.getNextSet(nArray[1]);
        int n4 = bitArray.getSize();
        int[] nArray2 = code93Reader.counters;
        Arrays.fill(code93Reader.counters, 0);
        StringBuilder stringBuilder = code93Reader.decodeRowResult;
        stringBuilder.setLength(0);
        while (true) {
            int n5;
            OneDReader.recordPattern((BitArray)resultPointArray, n3, nArray2);
            int n6 = Code93Reader.toPattern(nArray2);
            if (n6 < 0) break;
            char c2 = Code93Reader.patternToChar(n6);
            n6 = c2;
            stringBuilder.append(c2);
            int n7 = nArray2.length;
            int n8 = n3;
            for (n5 = 0; n5 < n7; ++n5) {
                n8 += nArray2[n5];
            }
            int n9 = n6;
            n6 = resultPointArray.getNextSet(n8);
            if (n9 == 42) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
                n7 = 0;
                n5 = nArray2.length;
                for (n8 = 0; n8 < n5; ++n8) {
                    n7 += nArray2[n8];
                }
                if (n6 != n4 && resultPointArray.get(n6)) {
                    if (stringBuilder.length() >= 2) {
                        ResultPoint resultPoint;
                        ResultPoint resultPoint2;
                        StringBuilder stringBuilder3 = stringBuilder;
                        Code93Reader.checkChecksums(stringBuilder3);
                        stringBuilder3.setLength(stringBuilder3.length() - 2);
                        resultPointArray = Code93Reader.decodeExtended(stringBuilder3);
                        float f2 = (float)(object[1] + object[0]) / 2.0f;
                        float f3 = (float)n3 + (float)n7 / 2.0f;
                        ResultPoint[] resultPointArray2 = resultPointArray;
                        ResultPoint[] resultPointArray3 = new ResultPoint[2];
                        resultPointArray = resultPointArray3;
                        ResultPoint resultPoint3 = resultPoint2;
                        float f4 = f2;
                        f2 = n2;
                        resultPoint2 = new ResultPoint(f4, f2);
                        resultPointArray3[0] = resultPoint3;
                        ResultPoint resultPoint4 = resultPoint;
                        resultPoint = new ResultPoint(f3, f2);
                        resultPointArray3[1] = resultPoint4;
                        BarcodeFormat barcodeFormat = BarcodeFormat.CODE_93;
                        return new Result((String)resultPointArray2, null, resultPointArray, barcodeFormat);
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            n3 = n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

