/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.multi;

import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import java.util.Map;

public final class ByQuadrantReader
implements Reader {
    private final Reader delegate;

    public ByQuadrantReader(Reader reader) {
        this.delegate = reader;
    }

    private static void makeAbsolute(ResultPoint[] resultPointArray, int n2, int n3) {
        if (resultPointArray != null) {
            for (int i2 = 0; i2 < resultPointArray.length; ++i2) {
                ResultPoint resultPoint = resultPointArray[i2];
                resultPointArray[i2] = new ResultPoint(resultPoint.getX() + (float)n2, resultPoint.getY() + (float)n3);
            }
        }
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        BinaryBitmap binaryBitmap2 = binaryBitmap;
        int n2 = binaryBitmap2.getWidth();
        n2 /= 2;
        int n3 = binaryBitmap2.getHeight() / 2;
        try {
            return this.delegate.decode(binaryBitmap.crop(0, 0, n2, n3), map);
        }
        catch (NotFoundException notFoundException) {
            try {
                Result result = this.delegate.decode(binaryBitmap.crop(n2, 0, n2, n3), map);
                ByQuadrantReader.makeAbsolute(result.getResultPoints(), n2, 0);
                return result;
            }
            catch (NotFoundException notFoundException2) {
                try {
                    Result result = this.delegate.decode(binaryBitmap.crop(0, n3, n2, n3), map);
                    ByQuadrantReader.makeAbsolute(result.getResultPoints(), 0, n3);
                    return result;
                }
                catch (NotFoundException notFoundException3) {
                    try {
                        Result result = this.delegate.decode(binaryBitmap.crop(n2, n3, n2, n3), map);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), n2, n3);
                        return result;
                    }
                    catch (NotFoundException notFoundException4) {
                        int n4 = n2 / 2;
                        int n5 = n3 / 2;
                        BinaryBitmap binaryBitmap3 = binaryBitmap.crop(n4, n5, n2, n3);
                        Result result = this.delegate.decode(binaryBitmap3, map);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), n4, n5);
                        return result;
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }
}

