/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.maxicode.decoder;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;
import com.dcloud.zxing2.maxicode.decoder.BitMatrixParser;
import com.dcloud.zxing2.maxicode.decoder.DecodedBitStreamParser;
import java.util.Map;

public final class Decoder {
    private static final int ALL = 0;
    private static final int EVEN = 1;
    private static final int ODD = 2;
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.MAXICODE_FIELD_64);

    private void correctErrors(byte[] byArray, int n2, int n3, int n4, int n5) throws ChecksumException {
        int n6 = n3 + n4;
        int n7 = n5 == 0 ? 1 : 2;
        int[] nArray = new int[n6 / n7];
        for (int i2 = 0; i2 < n6; ++i2) {
            if (n5 != 0 && i2 % 2 != n5 - 1) continue;
            int n8 = i2 / n7;
            nArray[n8] = byArray[i2 + n2] & 0xFF;
        }
        try {
            this.rsDecoder.decode(nArray, n4 / n7);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            if (n5 != 0 && i3 % 2 != n5 - 1) continue;
            n4 = i3 + n2;
            byArray[n4] = (byte)nArray[i3 / n7];
        }
        return;
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix object, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        byte[] byArray = new BitMatrixParser((BitMatrix)object).readCodewords();
        object = byArray;
        ((Decoder)object2).correctErrors((byte[])object, 0, 10, 10, 0);
        int n2 = byArray[0] & 0xF;
        switch (n2) {
            default: {
                throw FormatException.getFormatInstance();
            }
            case 5: {
                Decoder decoder = object2;
                decoder.correctErrors((byte[])object, 20, 68, 56, 1);
                decoder.correctErrors((byte[])object, 20, 68, 56, 2);
                Object object2 = new byte[78];
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Decoder decoder = object2;
                decoder.correctErrors((byte[])object, 20, 84, 40, 1);
                decoder.correctErrors((byte[])object, 20, 84, 40, 2);
                Object object2 = new byte[94];
            }
        }
        System.arraycopy(object, 0, object2, 0, 10);
        int n3 = ((Object)object2).length - 10;
        System.arraycopy(object, 20, object2, 10, n3);
        return DecodedBitStreamParser.decode((byte[])object2, n2);
    }
}

