/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;
import com.dcloud.zxing2.datamatrix.decoder.BitMatrixParser;
import com.dcloud.zxing2.datamatrix.decoder.DataBlock;
import com.dcloud.zxing2.datamatrix.decoder.DecodedBitStreamParser;
import com.dcloud.zxing2.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    private void correctErrors(byte[] byArray, int n2) throws ChecksumException {
        int n3 = byArray.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        int n4 = byArray.length - n2;
        try {
            this.rsDecoder.decode(nArray, n4);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n4 = 0; n4 < n2; ++n4) {
            byArray[n4] = (byte)nArray[n4];
        }
        return;
    }

    public DecoderResult decode(boolean[][] blArray) throws FormatException, ChecksumException {
        BitMatrix bitMatrix;
        int n2 = blArray.length;
        BitMatrix bitMatrix2 = bitMatrix;
        bitMatrix = new BitMatrix(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!blArray[i2][i3]) continue;
                bitMatrix2.set(i3, i2);
            }
        }
        return this.decode(bitMatrix2);
    }

    public DecoderResult decode(BitMatrix dataBlockArray) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser((BitMatrix)dataBlockArray);
        dataBlockArray = bitMatrixParser.getVersion();
        dataBlockArray = DataBlock.getDataBlocks(bitMatrixParser.readCodewords(), (Version)dataBlockArray);
        int n2 = dataBlockArray.length;
        int n3 = 0;
        int n4 = dataBlockArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 += dataBlockArray[i2].getNumDataCodewords();
        }
        byte[] byArray = new byte[n3];
        for (n4 = 0; n4 < n2; ++n4) {
            DataBlock dataBlock = dataBlockArray[n4];
            byte[] byArray2 = dataBlock.getCodewords();
            int n5 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray2, n5);
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n6++;
                int n8 = n7 * n2 + n4;
                byArray[n8] = byArray2[n7];
            }
        }
        return DecodedBitStreamParser.decode(byArray);
    }
}

