/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.datamatrix.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix mappingBitMatrix;
    private final BitMatrix readMappingMatrix;
    private final Version version;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n2 = bitMatrix.getHeight();
        if (n2 >= 8 && n2 <= 144 && (n2 & 1) == 0) {
            ((BitMatrixParser)((Object)bitMatrix2)).version = BitMatrixParser.readVersion(bitMatrix);
            BitMatrix bitMatrix2 = ((BitMatrixParser)((Object)bitMatrix2)).extractDataRegion(bitMatrix);
            v0.mappingBitMatrix = bitMatrix2;
            BitMatrix bitMatrix3 = bitMatrix2;
            int n3 = bitMatrix3.getWidth();
            v0.readMappingMatrix = new BitMatrix(n3, bitMatrix3.getHeight());
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static Version readVersion(BitMatrix bitMatrix) throws FormatException {
        return Version.getVersionForDimensions(bitMatrix.getHeight(), bitMatrix.getWidth());
    }

    Version getVersion() {
        return this.version;
    }

    byte[] readCodewords() throws FormatException {
        BitMatrixParser bitMatrixParser = this;
        byte[] byArray = new byte[bitMatrixParser.version.getTotalCodewords()];
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        int n5 = bitMatrixParser.mappingBitMatrix.getHeight();
        int n6 = bitMatrixParser.mappingBitMatrix.getWidth();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            if (n3 == n5 && n4 == 0 && !bl) {
                byArray[n2++] = (byte)this.readCorner1(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl = true;
                continue;
            }
            int n7 = n5 - 2;
            if (n3 == n7 && n4 == 0 && (n6 & 3) != 0 && !bl2) {
                byArray[n2++] = (byte)this.readCorner2(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl2 = true;
                continue;
            }
            if (n3 == n5 + 4 && n4 == 2 && (n6 & 7) == 0 && !bl3) {
                byArray[n2++] = (byte)this.readCorner3(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl3 = true;
                continue;
            }
            if (n3 == n7 && n4 == 0 && (n6 & 7) == 4 && !bl4) {
                byArray[n2++] = (byte)this.readCorner4(n5, n6);
                n3 -= 2;
                n4 += 2;
                bl4 = true;
                continue;
            }
            do {
                if (n3 >= n5 || n4 < 0 || this.readMappingMatrix.get(n4, n3)) continue;
                byArray[n2++] = (byte)this.readUtah(n3, n4, n5, n6);
            } while ((n3 += -2) >= 0 && (n4 += 2) < n6);
            ++n3;
            n4 += 3;
            do {
                if (n3 < 0 || n4 >= n6 || this.readMappingMatrix.get(n4, n3)) continue;
                byArray[n2++] = (byte)this.readUtah(n3, n4, n5, n6);
            } while ((n3 += 2) < n5 && (n4 -= 2) >= 0);
            n3 += 3;
            ++n4;
        } while (n3 < n5 || n4 < n6);
        if (n2 == this.version.getTotalCodewords()) {
            return byArray;
        }
        throw FormatException.getFormatInstance();
    }

    boolean readModule(int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            n2 += n4;
            n3 += 4 - (n4 + 4 & 7);
        }
        if (n3 < 0) {
            n3 += n5;
            n2 += 4 - (n5 + 4 & 7);
        }
        BitMatrixParser bitMatrixParser = this;
        bitMatrixParser.readMappingMatrix.set(n3, n2);
        return bitMatrixParser.mappingBitMatrix.get(n3, n2);
    }

    int readUtah(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n2 - 2;
        int n8 = n3 - 2;
        if (this.readModule(n7, n8, n4, n5)) {
            n6 = 1;
        }
        n6 <<= 1;
        if (this.readModule(n7, n7 = n3 - 1, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        int n9 = n2 - 1;
        if (this.readModule(n9, n8, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n9, n7, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n9, n3, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2, n8, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.readModule(n2, n7, n4, n5)) {
            n6 |= 1;
        }
        int n10 = n6 << 1;
        if (this.readModule(n2, n3, n4, n5)) {
            n10 |= 1;
        }
        return n10;
    }

    int readCorner1(int n2, int n3) {
        int n4 = 0;
        int n5 = n2 - 1;
        if (this.readModule(n5, 0, n2, n3)) {
            n4 = 1;
        }
        n4 <<= 1;
        if (this.readModule(n5, 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n5, 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        n5 = n3 - 1;
        if (this.readModule(0, n5, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n5, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(2, n5, n2, n3)) {
            n4 |= 1;
        }
        int n6 = n4 << 1;
        if (this.readModule(3, n5, n2, n3)) {
            n6 |= 1;
        }
        return n6;
    }

    int readCorner2(int n2, int n3) {
        int n4 = 0;
        if (this.readModule(n2 - 3, 0, n2, n3)) {
            n4 = 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 2, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 4, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 3, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        int n5 = n3 - 1;
        if (this.readModule(0, n5, n2, n3)) {
            n4 |= 1;
        }
        int n6 = n4 << 1;
        if (this.readModule(1, n5, n2, n3)) {
            n6 |= 1;
        }
        return n6;
    }

    int readCorner3(int n2, int n3) {
        int n4 = 0;
        int n5 = n2 - 1;
        if (this.readModule(n5, 0, n2, n3)) {
            n4 = 1;
        }
        n4 <<= 1;
        if (this.readModule(n5, n5 = n3 - 1, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        int n6 = n3 - 3;
        if (this.readModule(0, n6, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        int n7 = n3 - 2;
        if (this.readModule(0, n7, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n5, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n6, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n7, n2, n3)) {
            n4 |= 1;
        }
        int n8 = n4 << 1;
        if (this.readModule(1, n5, n2, n3)) {
            n8 |= 1;
        }
        return n8;
    }

    int readCorner4(int n2, int n3) {
        int n4 = 0;
        if (this.readModule(n2 - 3, 0, n2, n3)) {
            n4 = 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 2, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        int n5 = n3 - 1;
        if (this.readModule(0, n5, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(1, n5, n2, n3)) {
            n4 |= 1;
        }
        n4 <<= 1;
        if (this.readModule(2, n5, n2, n3)) {
            n4 |= 1;
        }
        int n6 = n4 << 1;
        if (this.readModule(3, n5, n2, n3)) {
            n6 |= 1;
        }
        return n6;
    }

    BitMatrix extractDataRegion(BitMatrix bitMatrix) {
        BitMatrixParser bitMatrixParser = this;
        int n2 = bitMatrixParser.version.getSymbolSizeRows();
        int n3 = bitMatrixParser.version.getSymbolSizeColumns();
        if (bitMatrix.getHeight() == n2) {
            BitMatrix bitMatrix2;
            int n4 = n3;
            int n5 = n2;
            n2 = this.version.getDataRegionSizeRows();
            int n6 = this.version.getDataRegionSizeColumns();
            n3 = n5 / n2;
            int n7 = n4 / n6;
            int n8 = n3 * n2;
            int n9 = n7 * n6;
            BitMatrix bitMatrix3 = bitMatrix2;
            bitMatrix2 = new BitMatrix(n9, n8);
            for (n8 = 0; n8 < n3; ++n8) {
                n9 = n8 * n2;
                for (int i2 = 0; i2 < n7; ++i2) {
                    int n10 = i2 * n6;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        int n11 = n8 * (n2 + 2) + 1 + i3;
                        int n12 = n9 + i3;
                        for (int i4 = 0; i4 < n6; ++i4) {
                            if (!bitMatrix.get(i2 * (n6 + 2) + 1 + i4, n11)) continue;
                            bitMatrix3.set(n10 + i4, n12);
                        }
                    }
                }
            }
            return bitMatrix3;
        }
        throw new IllegalArgumentException("Dimension of bitMarix must match the version size");
    }
}

