/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.reedsolomon;

import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.GenericGFPoly;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GenericGF field;

    public ReedSolomonDecoder(GenericGF genericGF) {
        this.field = genericGF;
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly genericGFPoly, GenericGFPoly genericGFPoly2, int n2) throws ReedSolomonException {
        if (genericGFPoly.getDegree() >= genericGFPoly2.getDegree()) {
            GenericGFPoly genericGFPoly3 = genericGFPoly;
            genericGFPoly = genericGFPoly2;
            genericGFPoly2 = genericGFPoly3;
        }
        ReedSolomonDecoder reedSolomonDecoder = this;
        GenericGFPoly genericGFPoly4 = reedSolomonDecoder.field.getZero();
        GenericGFPoly genericGFPoly5 = reedSolomonDecoder.field.getOne();
        while (genericGFPoly.getDegree() >= n2 / 2) {
            if (!genericGFPoly.isZero()) {
                GenericGFPoly genericGFPoly6 = genericGFPoly;
                GenericGFPoly genericGFPoly7 = this.field.getZero();
                int n3 = genericGFPoly6.getCoefficient(genericGFPoly6.getDegree());
                n3 = this.field.inverse(n3);
                while (genericGFPoly2.getDegree() >= genericGFPoly.getDegree() && !genericGFPoly2.isZero()) {
                    ReedSolomonDecoder reedSolomonDecoder2 = this;
                    int n4 = genericGFPoly2.getDegree() - genericGFPoly.getDegree();
                    GenericGFPoly genericGFPoly8 = genericGFPoly2;
                    int n5 = reedSolomonDecoder2.field.multiply(genericGFPoly8.getCoefficient(genericGFPoly8.getDegree()), n3);
                    GenericGFPoly genericGFPoly9 = genericGFPoly7.addOrSubtract(reedSolomonDecoder2.field.buildMonomial(n4, n5));
                    genericGFPoly2 = genericGFPoly2.addOrSubtract(genericGFPoly.multiplyByMonomial(n4, n5));
                    genericGFPoly7 = genericGFPoly9;
                }
                genericGFPoly4 = genericGFPoly7.multiply(genericGFPoly5).addOrSubtract(genericGFPoly4);
                if (genericGFPoly2.getDegree() < genericGFPoly.getDegree()) {
                    GenericGFPoly genericGFPoly10 = genericGFPoly2;
                    GenericGFPoly genericGFPoly11 = genericGFPoly4;
                    genericGFPoly4 = genericGFPoly5;
                    genericGFPoly2 = genericGFPoly;
                    genericGFPoly5 = genericGFPoly11;
                    genericGFPoly = genericGFPoly10;
                    continue;
                }
                throw new IllegalStateException("Division algorithm failed to reduce polynomial?");
            }
            throw new ReedSolomonException("r_{i-1} was zero");
        }
        int n6 = genericGFPoly5.getCoefficient(0);
        if (n6 != 0) {
            GenericGFPoly genericGFPoly12 = genericGFPoly;
            int n7 = this.field.inverse(n6);
            genericGFPoly = genericGFPoly5.multiply(n7);
            GenericGFPoly genericGFPoly13 = genericGFPoly12.multiply(n7);
            return new GenericGFPoly[]{genericGFPoly, genericGFPoly13};
        }
        throw new ReedSolomonException("sigmaTilde(0) was zero");
    }

    private int[] findErrorLocations(GenericGFPoly genericGFPoly) throws ReedSolomonException {
        int n2 = genericGFPoly.getDegree();
        if (n2 == 1) {
            return new int[]{genericGFPoly.getCoefficient(1)};
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 1; i2 < this.field.getSize() && n3 < n2; ++i2) {
            if (genericGFPoly.evaluateAt(i2) != 0) continue;
            nArray[n3] = this.field.inverse(i2);
            ++n3;
        }
        if (n3 == n2) {
            return nArray;
        }
        throw new ReedSolomonException("Error locator degree does not match number of roots");
    }

    private int[] findErrorMagnitudes(GenericGFPoly genericGFPoly, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.field.inverse(nArray[i2]);
            int n4 = 1;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i2 == i3) continue;
                int n5 = this.field.multiply(nArray[i3], n3);
                n5 = (n5 & 1) == 0 ? (n5 |= 1) : (n5 &= 0xFFFFFFFE);
                n4 = this.field.multiply(n4, n5);
            }
            nArray2[i2] = this.field.multiply(genericGFPoly.evaluateAt(n3), this.field.inverse(n4));
            if (this.field.getGeneratorBase() == 0) continue;
            nArray2[i2] = this.field.multiply(nArray2[i2], n3);
        }
        return nArray2;
    }

    public void decode(int[] nArray, int n2) throws ReedSolomonException {
        GenericGFPoly genericGFPoly;
        GenericGFPoly genericGFPoly2;
        Object object = genericGFPoly2;
        genericGFPoly2 = new GenericGFPoly(this.field, nArray);
        int[] nArray2 = new int[n2];
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            GenericGF genericGF = this.field;
            nArray2[n2 - 1 - i2] = n4 = ((GenericGFPoly)object).evaluateAt(genericGF.exp(i2 + genericGF.getGeneratorBase()));
            if (n4 == 0) continue;
            n3 = 0;
        }
        if (n3 != 0) {
            return;
        }
        ReedSolomonDecoder reedSolomonDecoder = this;
        object = genericGFPoly;
        genericGFPoly = new GenericGFPoly(this.field, nArray2);
        GenericGFPoly[] genericGFPolyArray = reedSolomonDecoder.runEuclideanAlgorithm(reedSolomonDecoder.field.buildMonomial(n2, 1), (GenericGFPoly)object, n2);
        Object object2 = genericGFPolyArray[0];
        object = genericGFPolyArray[1];
        object2 = reedSolomonDecoder.findErrorLocations((GenericGFPoly)object2);
        object = reedSolomonDecoder.findErrorMagnitudes((GenericGFPoly)object, (int[])object2);
        for (int i3 = 0; i3 < ((Object)object2).length; ++i3) {
            n3 = nArray.length - 1 - this.field.log((int)object2[i3]);
            if (n3 >= 0) {
                nArray[n3] = GenericGF.addOrSubtract(nArray[n3], (int)object[i3]);
                continue;
            }
            throw new ReedSolomonException("Bad error location");
        }
    }
}

