/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

public final class PerspectiveTransform {
    private final float a11;
    private final float a12;
    private final float a13;
    private final float a21;
    private final float a22;
    private final float a23;
    private final float a31;
    private final float a32;
    private final float a33;

    private PerspectiveTransform(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.a11 = f2;
        this.a12 = f5;
        this.a13 = f8;
        this.a21 = f3;
        this.a22 = f6;
        this.a23 = f9;
        this.a31 = f4;
        this.a32 = f7;
        this.a33 = f10;
    }

    public static PerspectiveTransform quadrilateralToQuadrilateral(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        PerspectiveTransform perspectiveTransform = PerspectiveTransform.quadrilateralToSquare(f2, f3, f4, f5, f6, f7, f8, f9);
        return PerspectiveTransform.squareToQuadrilateral(f10, f11, f12, f13, f14, f15, f16, f17).times(perspectiveTransform);
    }

    public static PerspectiveTransform squareToQuadrilateral(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11 = f2 - f4 + f6 - f8;
        float f12 = f3 - f5 + f7 - f9;
        if (f11 == 0.0f && f12 == 0.0f) {
            float f13 = f7;
            float f14 = f6;
            f6 = f4 - f2;
            f4 = f14 - f4;
            f7 = f5 - f3;
            f5 = f13 - f5;
            return new PerspectiveTransform(f6, f4, f2, f7, f5, f3, 0.0f, 0.0f, 1.0f);
        }
        float f15 = f4 - f6;
        float f16 = f10 = f15;
        float f17 = f7;
        f6 = f8 - f6;
        f7 = f5 - f7;
        f10 = f9 - f17;
        float f18 = f16 * f10 - f6 * f7;
        f6 = (f11 * f10 - f6 * f12) / f18;
        f7 = (f15 * f12 - f11 * f7) / f18;
        f4 = f4 - f2 + f6 * f4;
        f8 = f8 - f2 + f7 * f8;
        f5 = f5 - f3 + f6 * f5;
        f9 = f9 - f3 + f7 * f9;
        return new PerspectiveTransform(f4, f8, f2, f5, f9, f3, f6, f7, 1.0f);
    }

    public static PerspectiveTransform quadrilateralToSquare(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return PerspectiveTransform.squareToQuadrilateral(f2, f3, f4, f5, f6, f7, f8, f9).buildAdjoint();
    }

    public void transformPoints(float[] fArray) {
        PerspectiveTransform perspectiveTransform = this;
        int n2 = fArray.length;
        float f2 = perspectiveTransform.a11;
        float f3 = perspectiveTransform.a12;
        float f4 = perspectiveTransform.a13;
        float f5 = perspectiveTransform.a21;
        float f6 = perspectiveTransform.a22;
        float f7 = perspectiveTransform.a23;
        float f8 = perspectiveTransform.a31;
        float f9 = perspectiveTransform.a32;
        float f10 = perspectiveTransform.a33;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            float f11 = fArray[i2];
            int n3 = i2 + 1;
            float f12 = fArray[n3];
            float f13 = f4 * f11 + f7 * f12 + f10;
            fArray[i2] = (f2 * f11 + f5 * f12 + f8) / f13;
            fArray[n3] = (f3 * f11 + f6 * f12 + f9) / f13;
        }
    }

    public void transformPoints(float[] fArray, float[] fArray2) {
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PerspectiveTransform perspectiveTransform = this;
            float f2 = fArray[i2];
            float f3 = fArray2[i2];
            float f4 = perspectiveTransform.a13 * f2 + this.a23 * f3 + this.a33;
            fArray[i2] = (perspectiveTransform.a11 * f2 + this.a21 * f3 + this.a31) / f4;
            fArray2[i2] = (this.a12 * f2 + this.a22 * f3 + this.a32) / f4;
        }
    }

    PerspectiveTransform buildAdjoint() {
        PerspectiveTransform perspectiveTransform = this;
        float f2 = perspectiveTransform.a22;
        float f3 = this.a33;
        float f4 = f2 * f3;
        float f5 = perspectiveTransform.a23;
        float f6 = f4;
        f4 = this.a32;
        float f7 = f6 - f5 * f4;
        float f8 = this.a31;
        float f9 = f5 * f8;
        float f10 = perspectiveTransform.a21;
        f9 -= f10 * f3;
        float f11 = f10 * f4 - f2 * f8;
        float f12 = perspectiveTransform.a13;
        float f13 = this.a12;
        float f14 = f12 * f4 - f13 * f3;
        float f15 = perspectiveTransform.a11;
        float f16 = f2;
        f3 = f15 * f3 - f12 * f8;
        f4 = f13 * f8 - f15 * f4;
        f2 = f13 * f5 - f12 * f2;
        f5 = f12 * f10 - f15 * f5;
        f13 = f15 * f16 - f13 * f10;
        return new PerspectiveTransform(f7, f9, f11, f14, f3, f4, f2, f5, f13);
    }

    PerspectiveTransform times(PerspectiveTransform perspectiveTransform) {
        float f2;
        float f3;
        PerspectiveTransform perspectiveTransform2 = this;
        float f4 = perspectiveTransform2.a11;
        float f5 = f3 = f4;
        float f6 = f3;
        f3 = perspectiveTransform.a11;
        float f7 = this.a21;
        float f8 = perspectiveTransform.a12;
        float f9 = this.a31;
        float f10 = perspectiveTransform.a13;
        float f11 = f6 * f3 + f7 * f8 + f9 * f10;
        float f12 = perspectiveTransform.a21;
        float f13 = perspectiveTransform.a22;
        float f14 = perspectiveTransform.a23;
        float f15 = f5 * f12 + f7 * f13 + f9 * f14;
        float f16 = perspectiveTransform.a31;
        float f17 = f7;
        f7 = perspectiveTransform.a32;
        float f18 = perspectiveTransform.a33;
        f9 = f4 * f16 + f17 * f7 + f9 * f18;
        float f19 = perspectiveTransform2.a12;
        float f20 = f2 = f19;
        float f21 = f2 * f3;
        f2 = this.a22;
        float f22 = this.a32;
        float f23 = f21 + f2 * f8 + f22 * f10;
        float f24 = f20 * f12 + f2 * f13 + f22 * f14;
        f2 = f19 * f16 + f2 * f7 + f22 * f18;
        f22 = perspectiveTransform2.a13;
        float f25 = f22 * f3;
        f3 = this.a23;
        float f26 = this.a33;
        f8 = f25 + f3 * f8 + f26 * f10;
        f10 = f22 * f12 + f3 * f13 + f26 * f14;
        f26 = f22 * f16 + f3 * f7 + f26 * f18;
        return new PerspectiveTransform(f11, f15, f9, f23, f24, f2, f8, f10, f26);
    }
}

