/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.client.result;

import com.dcloud.zxing2.client.result.ParsedResult;
import com.dcloud.zxing2.client.result.ParsedResultType;
import com.dcloud.zxing2.client.result.ResultParser;
import java.util.regex.Pattern;

public final class URIParsedResult
extends ParsedResult {
    private static final Pattern USER_IN_HOST = Pattern.compile(":/*([^/@]+)@[^/]+");
    private final String uri;
    private final String title;

    public URIParsedResult(String string2, String string3) {
        super(ParsedResultType.URI);
        this.uri = URIParsedResult.massageURI(string2);
        this.title = string3;
    }

    private static String massageURI(String string2) {
        int n2 = (string2 = string2.trim()).indexOf(58);
        if (n2 < 0 || URIParsedResult.isColonFollowedByPortNumber(string2, n2)) {
            string2 = "http://" + string2;
        }
        return string2;
    }

    private static boolean isColonFollowedByPortNumber(String string2, int n2) {
        int n3;
        if ((n3 = string2.indexOf(47, ++n2)) < 0) {
            n3 = string2.length();
        }
        return ResultParser.isSubstringOfDigits(string2, n2, n3 - n2);
    }

    public String getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPossiblyMaliciousURI() {
        return USER_IN_HOST.matcher(this.uri).find();
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        URIParsedResult uRIParsedResult = this;
        stringBuilder2(30);
        ParsedResult.maybeAppend(uRIParsedResult.title, stringBuilder2);
        ParsedResult.maybeAppend(uRIParsedResult.uri, stringBuilder2);
        return stringBuilder.toString();
    }
}

