/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.encoder;

import com.dcloud.zxing2.aztec.encoder.State;
import com.dcloud.zxing2.common.BitArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public final class HighLevelEncoder {
    static final String[] MODE_NAMES;
    static final int MODE_UPPER = 0;
    static final int MODE_LOWER = 1;
    static final int MODE_DIGIT = 2;
    static final int MODE_MIXED = 3;
    static final int MODE_PUNCT = 4;
    static final int[][] LATCH_TABLE;
    private static final int[][] CHAR_MAP;
    static final int[][] SHIFT_TABLE;
    private final byte[] text;

    public HighLevelEncoder(byte[] byArray) {
        this.text = byArray;
    }

    private Collection<State> updateStateListForChar(Iterable<State> linkedList, int n2) {
        LinkedList<State> linkedList2;
        LinkedList<State> linkedList3 = linkedList;
        linkedList = linkedList2;
        linkedList2 = new LinkedList<State>();
        Iterator iterator = linkedList3.iterator();
        while (iterator.hasNext()) {
            this.updateStateForChar((State)iterator.next(), n2, linkedList);
        }
        return HighLevelEncoder.simplifyStates(linkedList);
    }

    private void updateStateForChar(State state, int n2, Collection<State> collection) {
        char c2 = (char)(this.text[n2] & 0xFF);
        boolean bl = CHAR_MAP[state.getMode()][c2] > 0;
        State state2 = null;
        for (int i2 = 0; i2 <= 4; ++i2) {
            int n3 = CHAR_MAP[i2][c2];
            if (n3 <= 0) continue;
            if (state2 == null) {
                state2 = state.endBinaryShift(n2);
            }
            if (!bl || i2 == state.getMode() || i2 == 2) {
                collection.add(state2.latchAndAppend(i2, n3));
            }
            if (bl || SHIFT_TABLE[state.getMode()][i2] < 0) continue;
            collection.add(state2.shiftAndAppend(i2, n3));
        }
        if (state.getBinaryShiftByteCount() > 0 || CHAR_MAP[state.getMode()][c2] == 0) {
            collection.add(state.addBinaryShiftChar(n2));
        }
    }

    private static Collection<State> updateStateListForPair(Iterable<State> linkedList, int n2, int n3) {
        LinkedList<State> linkedList2;
        LinkedList<State> linkedList3 = linkedList;
        linkedList = linkedList2;
        linkedList2 = new LinkedList<State>();
        Iterator iterator = linkedList3.iterator();
        while (iterator.hasNext()) {
            HighLevelEncoder.updateStateForPair((State)iterator.next(), n2, n3, linkedList);
        }
        return HighLevelEncoder.simplifyStates(linkedList);
    }

    private static void updateStateForPair(State state, int n2, int n3, Collection<State> collection) {
        State state2 = state.endBinaryShift(n2);
        collection.add(state2.latchAndAppend(4, n3));
        if (state.getMode() != 4) {
            collection.add(state2.shiftAndAppend(4, n3));
        }
        if (n3 == 3 || n3 == 4) {
            collection.add(state2.latchAndAppend(2, 16 - n3).latchAndAppend(2, 1));
        }
        if (state.getBinaryShiftByteCount() > 0) {
            collection.add(state.addBinaryShiftChar(n2).addBinaryShiftChar(n2 + 1));
        }
    }

    private static Collection<State> simplifyStates(Iterable<State> linkedList) {
        LinkedList<State> linkedList2;
        LinkedList<State> linkedList3 = linkedList;
        linkedList = linkedList2;
        linkedList2 = new LinkedList<State>();
        for (State state : linkedList3) {
            boolean bl = true;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                State state2 = (State)iterator.next();
                if (state2.isBetterThanOrEqualTo(state)) {
                    bl = false;
                    break;
                }
                if (!state.isBetterThanOrEqualTo(state2)) continue;
                iterator.remove();
            }
            if (!bl) continue;
            linkedList.add(state);
        }
        return linkedList;
    }

    static {
        int n2;
        MODE_NAMES = new String[]{"UPPER", "LOWER", "DIGIT", "MIXED", "PUNCT"};
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[5];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 327708;
        nArray[2] = 327710;
        nArray[3] = 327709;
        nArray[4] = 656318;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[5];
        nArray2 = nArray3;
        nArray3[0] = 590318;
        nArray3[1] = 0;
        nArray3[2] = 327710;
        nArray3[3] = 327709;
        nArray3[4] = 656318;
        nArrayArray[1] = nArray2;
        int[] nArray4 = new int[5];
        nArray2 = nArray4;
        nArray4[0] = 262158;
        nArray4[1] = 590300;
        nArray4[2] = 0;
        nArray4[3] = 590301;
        nArray4[4] = 932798;
        nArrayArray[2] = nArray2;
        int[] nArray5 = new int[5];
        nArray2 = nArray5;
        nArray5[0] = 327709;
        nArray5[1] = 327708;
        nArray5[2] = 656318;
        nArray5[3] = 0;
        nArray5[4] = 327710;
        nArrayArray[3] = nArray2;
        int[] nArray6 = new int[5];
        nArray2 = nArray6;
        nArray6[0] = 327711;
        nArray6[1] = 656380;
        nArray6[2] = 656382;
        nArray6[3] = 656381;
        nArray6[4] = 0;
        nArrayArray[4] = nArray2;
        LATCH_TABLE = nArrayArray;
        CHAR_MAP = new int[5][256];
        HighLevelEncoder.CHAR_MAP[0][32] = 1;
        int n3 = 65;
        while (n3 <= 90) {
            int n4 = n3++;
            HighLevelEncoder.CHAR_MAP[0][n4] = n4 - 65 + 2;
        }
        HighLevelEncoder.CHAR_MAP[1][32] = 1;
        n3 = 97;
        while (n3 <= 122) {
            int n5 = n3++;
            HighLevelEncoder.CHAR_MAP[1][n5] = n5 - 97 + 2;
        }
        HighLevelEncoder.CHAR_MAP[2][32] = 1;
        n3 = 48;
        while (n3 <= 57) {
            int n6 = n3++;
            HighLevelEncoder.CHAR_MAP[2][n6] = n6 - 48 + 2;
        }
        HighLevelEncoder.CHAR_MAP[2][44] = 12;
        HighLevelEncoder.CHAR_MAP[2][46] = 13;
        n3 = 28;
        int[] nArray7 = new int[28];
        int[] nArray8 = nArray7;
        nArray7[0] = 0;
        nArray7[1] = 32;
        nArray7[2] = 1;
        nArray7[3] = 2;
        nArray7[4] = 3;
        nArray7[5] = 4;
        nArray7[6] = 5;
        nArray7[7] = 6;
        nArray7[8] = 7;
        nArray7[9] = 8;
        nArray7[10] = 9;
        nArray7[11] = 10;
        nArray7[12] = 11;
        nArray7[13] = 12;
        nArray7[14] = 13;
        nArray7[15] = 27;
        nArray7[16] = 28;
        nArray7[17] = 29;
        nArray7[18] = 30;
        nArray7[19] = 31;
        nArray7[20] = 64;
        nArray7[21] = 92;
        nArray7[22] = 94;
        nArray7[23] = 95;
        nArray7[24] = 96;
        nArray7[25] = 124;
        nArray7[26] = 126;
        nArray7[27] = 127;
        for (n2 = 0; n2 < n3; ++n2) {
            HighLevelEncoder.CHAR_MAP[3][nArray8[n2]] = n2;
        }
        n3 = 31;
        int[] nArray9 = new int[31];
        nArray8 = nArray9;
        nArray9[0] = 0;
        nArray9[1] = 13;
        nArray9[2] = 0;
        nArray9[3] = 0;
        nArray9[4] = 0;
        nArray9[5] = 0;
        nArray9[6] = 33;
        nArray9[7] = 39;
        nArray9[8] = 35;
        nArray9[9] = 36;
        nArray9[10] = 37;
        nArray9[11] = 38;
        nArray9[12] = 39;
        nArray9[13] = 40;
        nArray9[14] = 41;
        nArray9[15] = 42;
        nArray9[16] = 43;
        nArray9[17] = 44;
        nArray9[18] = 45;
        nArray9[19] = 46;
        nArray9[20] = 47;
        nArray9[21] = 58;
        nArray9[22] = 59;
        nArray9[23] = 60;
        nArray9[24] = 61;
        nArray9[25] = 62;
        nArray9[26] = 63;
        nArray9[27] = 91;
        nArray9[28] = 93;
        nArray9[29] = 123;
        nArray9[30] = 125;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray8[n2] <= 0) continue;
            HighLevelEncoder.CHAR_MAP[4][nArray8[n2]] = n2;
        }
        int[][] nArray10 = new int[6][6];
        SHIFT_TABLE = nArray10;
        int n7 = nArray10.length;
        for (n2 = 0; n2 < n7; ++n2) {
            Arrays.fill(nArray10[n2], -1);
        }
        HighLevelEncoder.SHIFT_TABLE[0][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][0] = 28;
        HighLevelEncoder.SHIFT_TABLE[3][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][0] = 15;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BitArray encode() {
        var1_1 /* !! */  = Collections.singletonList(State.INITIAL_STATE);
        var2_2 = 0;
        while (true) {
            block5: {
                block6: {
                    block7: {
                        block8: {
                            var3_4 = this.text;
                            if (var2_2 >= this.text.length) break;
                            var4_5 = var2_2 + 1;
                            var5_6 = var4_5 < var3_4.length ? var3_4[var4_5] : 0;
                            var3_3 = var3_4[var2_2];
                            if (var3_3 == 13) break block6;
                            if (var3_3 == 44) break block7;
                            if (var3_3 == 46) break block8;
                            if (var3_3 != 58) lbl-1000:
                            // 5 sources

                            {
                                while (true) {
                                    var3_3 = 0;
                                    break block5;
                                    break;
                                }
                            }
                            if (var5_6 != 32) ** GOTO lbl-1000
                            var3_3 = 5;
                            break block5;
                        }
                        if (var5_6 != 32) ** GOTO lbl-1000
                        var3_3 = 3;
                        break block5;
                    }
                    if (var5_6 != 32) ** GOTO lbl-1000
                    var3_3 = 4;
                    break block5;
                }
                if (var5_6 == 10) ** break;
                ** continue;
                var3_3 = 2;
            }
            if (var3_3 > 0) {
                var1_1 /* !! */  = HighLevelEncoder.updateStateListForPair(var1_1 /* !! */ , var2_2, var3_3);
            } else {
                var1_1 /* !! */  = this.updateStateListForChar(var1_1 /* !! */ , var2_2);
                var4_5 = var2_2;
            }
            var2_2 = var4_5 + 1;
        }
        return Collections.min(var1_1 /* !! */ , new Comparator<State>(){

            @Override
            public int compare(State state, State state2) {
                return state.getBitCount() - state2.getBitCount();
            }
        }).toBitArray(this.text);
    }
}

