/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.encoder;

import com.dcloud.zxing2.aztec.encoder.AztecCode;
import com.dcloud.zxing2.aztec.encoder.HighLevelEncoder;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static AztecCode encode(byte[] var0, int var1_4, int var2_5) {
        block17: {
            block18: {
                block19: {
                    v0 = new HighLevelEncoder(var0 /* !! */ ).encode();
                    var0 /* !! */  = (byte[])v0;
                    var1_4 = v0.getSize() * var1_4 / 100 + 11;
                    var3_8 = v0.getSize() + var1_4;
                    if (var2_5 == 0) break block17;
                    var3_8 = var2_5 < 0 ? 1 : 0;
                    var4_9 = Math.abs(var2_5);
                    if (var4_9 > (var5_12 = var3_8 != 0 ? 4 : 32)) break block18;
                    var0_1 = Encoder.totalBitsInLayer(var4_9, (boolean)var3_8);
                    var2_5 = Encoder.WORD_SIZE[var4_9];
                    var5_12 = var0_1 - var0_1 % var2_5;
                    var6_14 = Encoder.stuffBits((BitArray)var0 /* !! */ , var2_5);
                    if (var6_14.getSize() + var1_4 > var5_12) break block19;
                    if (var3_8 != 0 && var6_14.getSize() > var2_5 * 64) {
                        throw new IllegalArgumentException("Data to large for user specified layer");
                    }
                    var7_16 = var4_9;
                    var6_15 = var3_8;
                    var8_17 = var0_1;
                    var4_10 = var6_14;
                    ** GOTO lbl43
                }
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            v1 = new Object[1];
            var0 /* !! */  = (byte[])v1;
            v1[0] = var2_5;
            throw new IllegalArgumentException(String.format("Illegal value %s for layers", var0 /* !! */ ));
        }
        var2_5 = 0;
        var4_10 = null;
        for (var5_12 = 0; var5_12 <= 32; ++var5_12) {
            var6_15 = var5_12 <= 3 ? 1 : 0;
            var7_16 = var6_15 != 0 ? var5_12 + 1 : var5_12;
            var8_17 = Encoder.totalBitsInLayer(var7_16, (boolean)var6_15);
            if (var3_8 > var8_17) continue;
            var9_19 = Encoder.WORD_SIZE;
            if (var2_5 != Encoder.WORD_SIZE[var7_16]) {
                var2_5 = var9_19[var7_16];
                var4_10 = Encoder.stuffBits((BitArray)var0 /* !! */ , var2_5);
            }
            v2 = var8_17;
            var9_18 = v2 - v2 % var2_5;
            if (var6_15 != 0 && var4_10.getSize() > var2_5 * 64 || var4_10.getSize() + var1_4 > var9_18) continue;
lbl43:
            // 2 sources

            v3 = var6_15;
            v4 = var4_10;
            var0_2 = Encoder.generateCheckWords(v4, var8_17, var2_5);
            var1_4 = v4.getSize() / var2_5;
            var2_6 = Encoder.generateModeMessage((boolean)v3, var7_16, var1_4);
            var3_8 = v3 != 0 ? var7_16 * 4 + 11 : var7_16 * 4 + 14;
            var4_10 = new int[var3_8];
            if (var6_15 != 0) {
                var5_12 = 0;
                while (var5_12 < var3_8) {
                    v5 = var5_12++;
                    var4_10[v5] = v5;
                }
                var8_17 = var3_8;
            } else {
                var5_12 = var3_8 / 2;
                var8_17 = var3_8 + 1 + (var5_12 - 1) / 15 * 2;
                var9_18 = var8_17 / 2;
                for (var10_20 = 0; var10_20 < var5_12; ++var10_20) {
                    v6 = var10_20;
                    var11_21 = v6 + v6 / 15;
                    var12_22 = var5_12 - v6 - 1;
                    var4_10[var12_22] = var9_18 - var11_21 - 1;
                    var12_22 = var5_12 + var10_20;
                    var4_10[var12_22] = var9_18 + var11_21 + 1;
                }
            }
            var5_13 = v7;
            v7 = new BitMatrix(var8_17);
            var10_20 = 0;
            for (var9_18 = 0; var9_18 < var7_16; ++var9_18) {
                var11_21 = var6_15 != 0 ? (var7_16 - var9_18) * 4 + 9 : (var7_16 - var9_18) * 4 + 12;
                for (var12_22 = 0; var12_22 < var11_21; ++var12_22) {
                    var13_23 = var12_22 * 2;
                    for (var14_24 = 0; var14_24 < 2; ++var14_24) {
                        if (var0_2.get(var10_20 + var13_23 + var14_24)) {
                            v8 = var9_18 * 2;
                            var15_25 /* !! */  = v8;
                            var15_25 /* !! */  = (int)var4_10[var15_25 /* !! */  + var14_24];
                            var5_13.set(var15_25 /* !! */ , (int)var4_10[v8 + var12_22]);
                        }
                        if (var0_2.get(var10_20 + var11_21 * 2 + var13_23 + var14_24)) {
                            var15_25 /* !! */  = var9_18 * 2;
                            var16_26 /* !! */  = var4_10[var15_25 /* !! */  + var12_22];
                            var5_13.set((int)var16_26 /* !! */ , (int)var4_10[var3_8 - 1 - var15_25 /* !! */  - var14_24]);
                        }
                        if (var0_2.get(var10_20 + var11_21 * 4 + var13_23 + var14_24)) {
                            v9 = var3_8 - 1 - var9_18 * 2;
                            var15_25 /* !! */  = v9;
                            var15_25 /* !! */  = (int)var4_10[var15_25 /* !! */  - var14_24];
                            var5_13.set(var15_25 /* !! */ , (int)var4_10[v9 - var12_22]);
                        }
                        if (!var0_2.get(var10_20 + var11_21 * 6 + var13_23 + var14_24)) continue;
                        var15_25 /* !! */  = var3_8 - 1;
                        v10 = var9_18 * 2;
                        var16_26 /* !! */  = v10;
                        var15_25 /* !! */  = (int)var4_10[var15_25 /* !! */  - var16_26 /* !! */  - var12_22];
                        var5_13.set(var15_25 /* !! */ , (int)var4_10[v10 + var14_24]);
                    }
                }
                var10_20 += var11_21 * 8;
            }
            Encoder.drawModeMessage(var5_13, (boolean)var6_15, var8_17, var2_6);
            if (var6_15 != 0) {
                Encoder.drawBullsEye(var5_13, var8_17 / 2, 5);
            } else {
                var0_3 = var8_17 / 2;
                Encoder.drawBullsEye(var5_13, var0_3, 7);
                var2_7 = 0;
                var4_11 = 0;
                while (var2_7 < var3_8 / 2 - 1) {
                    for (var9_18 = var0_3 & 1; var9_18 < var8_17; var9_18 += 2) {
                        v11 = var5_13;
                        var10_20 = var0_3 - var4_11;
                        var5_13.set(var10_20, var9_18);
                        var11_21 = var0_3 + var4_11;
                        v11.set(var11_21, var9_18);
                        v11.set(var9_18, var10_20);
                        v11.set(var9_18, var11_21);
                    }
                    var2_7 += 15;
                    var4_11 += 16;
                }
            }
            v12 = new AztecCode();
            v12.setCompact((boolean)var6_15);
            v12.setSize(var8_17);
            v12.setLayers(var7_16);
            v12.setCodeWords(var1_4);
            v12.setMatrix(var5_13);
            return v12;
        }
        throw new IllegalArgumentException("Data too large for an Aztec code");
    }

    private static void drawBullsEye(BitMatrix bitMatrix, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < n3; n4 += 2) {
            int n5;
            int n6;
            for (int i2 = n5 = n2 - n4; i2 <= (n6 = n2 + n4); ++i2) {
                BitMatrix bitMatrix2 = bitMatrix;
                bitMatrix2.set(i2, n5);
                bitMatrix2.set(i2, n6);
                bitMatrix2.set(n5, i2);
                bitMatrix2.set(n6, i2);
            }
        }
        int n7 = n2;
        BitMatrix bitMatrix3 = bitMatrix;
        bitMatrix3.set(n2 -= n3, n2);
        n4 = n2 + 1;
        bitMatrix3.set(n4, n2);
        bitMatrix3.set(n2, n4);
        n3 = n7 + n3;
        BitMatrix bitMatrix4 = bitMatrix;
        bitMatrix4.set(n3, n2);
        bitMatrix4.set(n3, n4);
        bitMatrix.set(n3, n3 - 1);
    }

    static BitArray generateModeMessage(boolean bl, int n2, int n3) {
        BitArray bitArray;
        BitArray bitArray2;
        BitArray bitArray3 = bitArray2;
        bitArray2 = new BitArray();
        if (bl) {
            BitArray bitArray4 = bitArray3;
            bitArray3.appendBits(n2 - 1, 2);
            bitArray4.appendBits(n3 - 1, 6);
            bitArray = Encoder.generateCheckWords(bitArray4, 28, 4);
        } else {
            BitArray bitArray5 = bitArray3;
            bitArray3.appendBits(n2 - 1, 5);
            bitArray5.appendBits(n3 - 1, 11);
            bitArray = Encoder.generateCheckWords(bitArray5, 40, 4);
        }
        return bitArray;
    }

    /*
     * WARNING - void declaration
     */
    private static void drawModeMessage(BitMatrix bitMatrix, boolean bl, int n2, BitArray bitArray) {
        void var3_4;
        int n3;
        void var1_2 = n3 / 2;
        if (bl) {
            for (n3 = 0; n3 < 7; ++n3) {
                void n4 = var1_2 - 3 + n3;
                if (var3_4.get(n3)) {
                    bitMatrix.set((int)n4, (int)(var1_2 - 5));
                }
                if (var3_4.get(n3 + 7)) {
                    bitMatrix.set((int)(var1_2 + 5), (int)n4);
                }
                if (var3_4.get(20 - n3)) {
                    bitMatrix.set((int)n4, (int)(var1_2 + 5));
                }
                if (!var3_4.get(27 - n3)) continue;
                bitMatrix.set((int)(var1_2 - 5), (int)n4);
            }
        } else {
            for (n3 = 0; n3 < 10; ++n3) {
                void var4_6 = var1_2 - 5 + n3 + n3 / 5;
                if (var3_4.get(n3)) {
                    bitMatrix.set((int)var4_6, (int)(var1_2 - 7));
                }
                if (var3_4.get(n3 + 10)) {
                    bitMatrix.set((int)(var1_2 + 7), (int)var4_6);
                }
                if (var3_4.get(29 - n3)) {
                    bitMatrix.set((int)var4_6, (int)(var1_2 + 7));
                }
                if (!var3_4.get(39 - n3)) continue;
                bitMatrix.set((int)(var1_2 - 7), (int)var4_6);
            }
        }
    }

    private static BitArray generateCheckWords(BitArray bitArray, int n2, int n3) {
        BitArray bitArray2;
        ReedSolomonEncoder reedSolomonEncoder;
        int n4 = bitArray.getSize() / n3;
        ReedSolomonEncoder reedSolomonEncoder2 = reedSolomonEncoder;
        reedSolomonEncoder = new ReedSolomonEncoder(Encoder.getGF(n3));
        int n5 = n2 / n3;
        int[] nArray = Encoder.bitsToWords(bitArray, n3, n5);
        reedSolomonEncoder2.encode(nArray, n5 - n4);
        n4 = n2 % n3;
        BitArray bitArray3 = bitArray2;
        new BitArray().appendBits(0, n4);
        n4 = nArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            bitArray3.appendBits(nArray[i2], n3);
        }
        return bitArray3;
    }

    private static int[] bitsToWords(BitArray bitArray, int n2, int n3) {
        int[] nArray = new int[n3];
        int n4 = bitArray.getSize() / n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = bitArray.get(i2 * n2 + i3) ? 1 << n2 - i3 - 1 : 0;
                n5 |= n6;
            }
            nArray[i2] = n5;
        }
        return nArray;
    }

    private static GenericGF getGF(int n2) {
        if (n2 != 4) {
            if (n2 != 6) {
                if (n2 != 8) {
                    if (n2 != 10) {
                        if (n2 == 12) {
                            return GenericGF.AZTEC_DATA_12;
                        }
                        throw new IllegalArgumentException("Unsupported word size " + n2);
                    }
                    return GenericGF.AZTEC_DATA_10;
                }
                return GenericGF.AZTEC_DATA_8;
            }
            return GenericGF.AZTEC_DATA_6;
        }
        return GenericGF.AZTEC_PARAM;
    }

    static BitArray stuffBits(BitArray bitArray, int n2) {
        BitArray bitArray2;
        BitArray bitArray3 = bitArray2;
        bitArray2 = new BitArray();
        int n3 = bitArray.getSize();
        int n4 = (1 << n2) - 2;
        for (int i2 = 0; i2 < n3; i2 += n2) {
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                int n7 = i2 + n5;
                if (n7 < n3 && !bitArray.get(n7)) continue;
                n6 |= 1 << n2 - 1 - n5;
            }
            n5 = n6 & n4;
            if (n5 == n4) {
                bitArray3.appendBits(n5, n2);
                --i2;
                continue;
            }
            if (n5 == 0) {
                bitArray3.appendBits(n6 | 1, n2);
                --i2;
                continue;
            }
            bitArray3.appendBits(n6, n2);
        }
        return bitArray3;
    }

    private static int totalBitsInLayer(int n2, boolean bl) {
        return ((bl ? 88 : 112) + n2 * 16) * n2;
    }
}

