/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.aztec.AztecDetectorResult;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.GridSampler;
import com.dcloud.zxing2.common.detector.MathUtils;
import com.dcloud.zxing2.common.detector.WhiteRectangleDetector;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;

public final class Detector {
    private static final int[] EXPECTED_CORNER_BITS = new int[]{3808, 476, 2107, 1799};
    private final BitMatrix image;
    private boolean compact;
    private int nbLayers;
    private int nbDataBlocks;
    private int nbCenterLayers;
    private int shift;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private void extractParameters(ResultPoint[] object) throws NotFoundException {
        if (this.isValid(object[0]) && this.isValid(object[1]) && this.isValid(object[2]) && this.isValid(object[3])) {
            int n2;
            int n3 = this.nbCenterLayers * 2;
            int[] nArray = new int[4];
            object = object[0];
            nArray[0] = this.sampleLine((ResultPoint)object, object[1], n3);
            object = object[1];
            nArray[1] = this.sampleLine((ResultPoint)object, object[2], n3);
            object = object[2];
            nArray[2] = this.sampleLine((ResultPoint)object, object[3], n3);
            object = object[3];
            nArray[3] = this.sampleLine((ResultPoint)object, object[0], n3);
            this.shift = Detector.getRotation(nArray, n3);
            long l2 = 0L;
            for (n2 = 0; n2 < 4; ++n2) {
                n3 = nArray[(this.shift + n2) % 4];
                l2 = this.compact ? (l2 << 7) + (long)(n3 >> 1 & 0x7F) : (l2 << 10) + (long)((n3 >> 2 & 0x3E0) + (n3 >> 1 & 0x1F));
            }
            n2 = Detector.getCorrectedParameterData(l2, this.compact);
            if (this.compact) {
                this.nbLayers = (n2 >> 6) + 1;
                this.nbDataBlocks = (n2 & 0x3F) + 1;
            } else {
                this.nbLayers = (n2 >> 11) + 1;
                this.nbDataBlocks = (n2 & 0x7FF) + 1;
            }
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int getRotation(int[] nArray, int n2) throws NotFoundException {
        int n3 = 0;
        int n4 = nArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            n3 = nArray[i2];
            n3 = (n3 >> n2 - 2 << 1) + (n3 & 1);
            n3 = (n5 << 3) + n3;
        }
        int n6 = ((n3 & 1) << 11) + (n3 >> 1);
        for (n2 = 0; n2 < 4; ++n2) {
            if (Integer.bitCount(n6 ^ EXPECTED_CORNER_BITS[n2]) > 2) continue;
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    /*
     * WARNING - void declaration
     */
    private static int getCorrectedParameterData(long l2, boolean bl) throws NotFoundException {
        int n2;
        ReedSolomonDecoder reedSolomonDecoder;
        void var2_6;
        int n3;
        if (bl) {
            int n4 = 7;
            n3 = 2;
        } else {
            int n5 = 10;
            n3 = 4;
        }
        void v0 = var2_6;
        void var2_7 = v0 - n3;
        int[] nArray = new int[v0];
        for (void var5_10 = (v968211) - true; var5_10 >= 0; --var5_10) {
            nArray[var5_10] = (int)l2 & 0xF;
            l2 >>= 4;
        }
        ReedSolomonDecoder reedSolomonDecoder2 = reedSolomonDecoder;
        try {
            reedSolomonDecoder2(GenericGF.AZTEC_PARAM);
            reedSolomonDecoder.decode(nArray, (int)var2_7);
            n2 = 0;
        }
        catch (ReedSolomonException reedSolomonException) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = (n2 << 4) + nArray[i2];
        }
        return n2;
    }

    private ResultPoint[] getBullsEyeCorners(Point object) throws NotFoundException {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        boolean bl = true;
        this.nbCenterLayers = 1;
        Point point = object;
        Object object2 = object;
        Object object3 = object;
        boolean bl2 = bl;
        while (this.nbCenterLayers < 9) {
            double d2;
            Detector detector = this;
            Point point2 = this.getFirstDifferent((Point)object, bl2, 1, -1);
            Point point3 = this.getFirstDifferent((Point)object3, bl2, 1, 1);
            Point point4 = this.getFirstDifferent((Point)object2, bl2, -1, 1);
            Point point5 = detector.getFirstDifferent(point, bl2, -1, -1);
            if (detector.nbCenterLayers > 2 && ((d2 = (double)(Detector.distance(point5, point2) * (float)this.nbCenterLayers / (Detector.distance(point, (Point)object) * (float)(this.nbCenterLayers + 2)))) < 0.75 || d2 > 1.25 || !this.isWhiteOrBlackRectangle(point2, point3, point4, point5))) break;
            boolean bl3 = bl2 ^ true;
            ++this.nbCenterLayers;
            point = point5;
            object2 = point4;
            object3 = point3;
            bl2 = bl3;
            object = point2;
        }
        if (!(bl2 = this.nbCenterLayers) && !bl2) {
            throw NotFoundException.getNotFoundInstance();
        }
        bl2 = bl2;
        this.compact = bl2;
        ResultPoint resultPoint5 = resultPoint4;
        resultPoint4 = new ResultPoint((float)((Point)object).getX() + 0.5f, (float)((Point)object).getY() - 0.5f);
        object = resultPoint3;
        resultPoint3 = new ResultPoint((float)((Point)object3).getX() + 0.5f, (float)((Point)object3).getY() + 0.5f);
        object3 = resultPoint2;
        resultPoint2 = new ResultPoint((float)((Point)object2).getX() - 0.5f, (float)((Point)object2).getY() + 0.5f);
        object2 = resultPoint;
        resultPoint = new ResultPoint((float)point.getX() - 0.5f, (float)point.getY() - 0.5f);
        int n2 = this.nbCenterLayers;
        float f2 = n2 * 2 - 3;
        return Detector.expandSquare(new ResultPoint[]{resultPoint5, object, object3, object2}, f2, n2 * 2);
    }

    private Point getMatrixCenter() {
        ResultPoint resultPoint;
        Object object;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        ResultPoint[] resultPointArray = new WhiteRectangleDetector(((Detector)object).image).detect();
        ResultPoint[] resultPointArray2 = resultPointArray;
        ResultPoint[] resultPointArray3 = resultPointArray;
        ResultPoint[] resultPointArray4 = resultPointArray;
        ResultPoint resultPoint5 = resultPointArray[0];
        ResultPoint resultPoint6 = resultPointArray2[1];
        ResultPoint resultPoint7 = resultPointArray3[2];
        try {
            resultPoint4 = resultPointArray4[3];
            resultPoint3 = resultPoint6;
            resultPoint6 = resultPoint7;
        }
        catch (NotFoundException notFoundException) {
            Detector detector = object;
            int n2 = detector.image.getWidth() / 2;
            int n3 = detector.image.getHeight() / 2;
            int n4 = n2 + 7;
            int n5 = n3 - 7;
            resultPoint2 = detector.getFirstDifferent(new Point(n4, n5), false, 1, -1).toResultPoint();
            resultPoint7 = detector.getFirstDifferent(new Point(n4, n3 += 7), false, 1, 1).toResultPoint();
            resultPoint6 = detector.getFirstDifferent(new Point(n2 -= 7, n3), false, -1, 1).toResultPoint();
            resultPoint4 = detector.getFirstDifferent(new Point(n2, n5), false, -1, -1).toResultPoint();
        }
        resultPoint7 = resultPoint3;
        resultPoint2 = resultPoint5;
        ResultPoint resultPoint8 = resultPoint2;
        int n6 = MathUtils.round((resultPoint8.getX() + resultPoint4.getX() + resultPoint7.getX() + resultPoint6.getX()) / 4.0f);
        int n7 = MathUtils.round((resultPoint8.getY() + resultPoint4.getY() + resultPoint7.getY() + resultPoint6.getY()) / 4.0f);
        ResultPoint[] resultPointArray5 = new WhiteRectangleDetector(((Detector)object).image, 15, n6, n7).detect();
        ResultPoint[] resultPointArray6 = resultPointArray5;
        ResultPoint[] resultPointArray7 = resultPointArray5;
        ResultPoint[] resultPointArray8 = resultPointArray5;
        resultPoint7 = resultPointArray5[0];
        resultPoint4 = resultPointArray6[1];
        resultPoint2 = resultPointArray7[2];
        try {
            object = resultPointArray8[3];
            resultPoint = resultPoint4;
            resultPoint4 = resultPoint7;
        }
        catch (NotFoundException notFoundException) {
            Detector detector = object;
            int n8 = n6 + 7;
            int n9 = n7 - 7;
            resultPoint4 = detector.getFirstDifferent(new Point(n8, n9), false, 1, -1).toResultPoint();
            int n10 = n8;
            n8 = n7 + 7;
            resultPoint = detector.getFirstDifferent(new Point(n10, n8), false, 1, 1).toResultPoint();
            resultPoint2 = detector.getFirstDifferent(new Point(n6 -= 7, n8), false, -1, 1).toResultPoint();
            object = detector.getFirstDifferent(new Point(n6, n9), false, -1, -1).toResultPoint();
        }
        ResultPoint resultPoint9 = resultPoint4;
        n6 = MathUtils.round((resultPoint9.getX() + ((ResultPoint)object).getX() + resultPoint.getX() + resultPoint2.getX()) / 4.0f);
        int n11 = MathUtils.round((resultPoint9.getY() + ((ResultPoint)object).getY() + resultPoint.getY() + resultPoint2.getY()) / 4.0f);
        return new Point(n6, n11);
    }

    private ResultPoint[] getMatrixCornerPoints(ResultPoint[] resultPointArray) {
        return Detector.expandSquare(resultPointArray, this.nbCenterLayers * 2, this.getDimension());
    }

    private BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        ResultPoint resultPoint5 = resultPoint4;
        ResultPoint resultPoint6 = resultPoint3;
        ResultPoint resultPoint7 = resultPoint2;
        ResultPoint resultPoint8 = resultPoint;
        int n2 = this.getDimension();
        float f2 = (float)n2 / 2.0f;
        int n3 = this.nbCenterLayers;
        float f3 = f2 - (float)n3;
        float f4 = f2 + (float)n3;
        float f5 = resultPoint8.getX();
        float f6 = resultPoint8.getY();
        float f7 = resultPoint7.getX();
        float f8 = resultPoint7.getY();
        float f9 = resultPoint6.getX();
        float f10 = resultPoint6.getY();
        float f11 = resultPoint5.getX();
        float f12 = resultPoint5.getY();
        int n4 = n2;
        float f13 = f3;
        float f14 = f4;
        return GridSampler.getInstance().sampleGrid(bitMatrix, n4, n4, f13, f13, f4, f3, f14, f14, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    private int sampleLine(ResultPoint resultPoint, ResultPoint resultPoint2, int n2) {
        int n3 = 0;
        float f2 = Detector.distance(resultPoint, resultPoint2);
        float f3 = f2 / (float)n2;
        ResultPoint resultPoint3 = resultPoint;
        float f4 = resultPoint3.getX();
        float f5 = resultPoint3.getY();
        float f6 = f3 * (resultPoint2.getX() - resultPoint.getX()) / f2;
        float f7 = f3 * (resultPoint2.getY() - resultPoint.getY()) / f2;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f8 = i2;
            int n4 = MathUtils.round(f4 + f8 * f6);
            if (!this.image.get(n4, MathUtils.round(f5 + f8 * f7))) continue;
            n3 |= 1 << n2 - i2 - 1;
        }
        return n3;
    }

    private boolean isWhiteOrBlackRectangle(Point point, Point point2, Point point3, Point point4) {
        Point point5;
        Point point6;
        Point point7;
        Point point8;
        Point point9 = point8;
        point8 = new Point(point.getX() - 3, point.getY() + 3);
        point = point7;
        point7 = new Point(point2.getX() - 3, point2.getY() - 3);
        point2 = point6;
        point6 = new Point(point3.getX() + 3, point3.getY() - 3);
        point3 = point5;
        point3(point4.getX() + 3, point4.getY() + 3);
        int n2 = this.getColor(point5, point9);
        if (n2 == 0) {
            return false;
        }
        if (this.getColor(point9, point) != n2) {
            return false;
        }
        if (this.getColor(point, point2) != n2) {
            return false;
        }
        return this.getColor(point2, point3) == n2;
    }

    private int getColor(Point point, Point point2) {
        float f2;
        Point point3 = point;
        Point point4 = point2;
        float f3 = Detector.distance(point, point2);
        float f4 = (float)(point4.getX() - point.getX()) / f3;
        float f5 = (float)(point4.getY() - point.getY()) / f3;
        int n2 = 0;
        float f6 = point3.getX();
        float f7 = point3.getY();
        Point point5 = point;
        int n3 = point5.getX();
        n3 = this.image.get(n3, point5.getY()) ? 1 : 0;
        int n4 = 0;
        while ((float)n4 < f3) {
            int n5 = MathUtils.round(f6 += f4);
            if (this.image.get(n5, MathUtils.round(f7 += f5)) != n3) {
                ++n2;
            }
            ++n4;
        }
        float f8 = (float)n2 / f3;
        if (f2 > 0.1f && f8 < 0.9f) {
            return 0;
        }
        return (f8 <= 0.1f ? 1 : 0) == n3 ? 1 : -1;
    }

    private Point getFirstDifferent(Point point, boolean bl, int n2, int n3) {
        Point point2 = point;
        int n4 = point2.getX() + n2;
        int n5 = point2.getY() + n3;
        while (this.isValid(n4, n5) && this.image.get(n4, n5) == bl) {
            n4 += n2;
            n5 += n3;
        }
        n4 -= n2;
        n5 -= n3;
        while (this.isValid(n4, n5) && this.image.get(n4, n5) == bl) {
            n4 += n2;
        }
        n4 -= n2;
        while (this.isValid(n4, n5) && this.image.get(n4, n5) == bl) {
            n5 += n3;
        }
        int n6 = n5 - n3;
        return new Point(n4, n6);
    }

    private static ResultPoint[] expandSquare(ResultPoint[] resultPointArray, float f2, float f3) {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        f2 = f3 / (f2 * 2.0f);
        f3 = resultPointArray[0].getX() - resultPointArray[2].getX();
        float f4 = resultPointArray[0].getY() - resultPointArray[2].getY();
        float f5 = (resultPointArray[0].getX() + resultPointArray[2].getX()) / 2.0f;
        float f6 = (resultPointArray[0].getY() + resultPointArray[2].getY()) / 2.0f;
        ResultPoint resultPoint5 = resultPoint4;
        float f7 = f4;
        f3 = f2 * f3;
        f4 = f5 + f3;
        float f8 = f2 * f7;
        resultPoint4 = new ResultPoint(f4, f6 + f8);
        ResultPoint resultPoint6 = resultPoint3;
        f3 = f5 - f3;
        resultPoint3 = new ResultPoint(f3, f6 - f8);
        f3 = resultPointArray[1].getX() - resultPointArray[3].getX();
        f5 = resultPointArray[1].getY() - resultPointArray[3].getY();
        f6 = (resultPointArray[1].getX() + resultPointArray[3].getX()) / 2.0f;
        float f9 = (resultPointArray[1].getY() + resultPointArray[3].getY()) / 2.0f;
        ResultPoint resultPoint7 = resultPoint2;
        float f10 = f2;
        f2 *= f3;
        f3 = f6 + f2;
        f5 = f10 * f5;
        resultPoint2 = new ResultPoint(f3, f9 + f5);
        ResultPoint resultPoint8 = resultPoint;
        float f11 = f9;
        f9 = f6 - f2;
        resultPoint = new ResultPoint(f9, f11 - f5);
        return new ResultPoint[]{resultPoint5, resultPoint7, resultPoint6, resultPoint8};
    }

    private boolean isValid(int n2, int n3) {
        return n2 >= 0 && n2 < this.image.getWidth() && n3 > 0 && n3 < this.image.getHeight();
    }

    private boolean isValid(ResultPoint resultPoint) {
        return this.isValid(MathUtils.round(resultPoint.getX()), MathUtils.round(resultPoint.getY()));
    }

    private static float distance(Point point, Point point2) {
        Point point3 = point2;
        int n2 = point.getY();
        int n3 = point3.getX();
        int n4 = point3.getY();
        return MathUtils.distance(point.getX(), n2, n3, n4);
    }

    private static float distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        ResultPoint resultPoint3 = resultPoint2;
        float f2 = resultPoint.getY();
        float f3 = resultPoint3.getX();
        float f4 = resultPoint3.getY();
        return MathUtils.distance(resultPoint.getX(), f2, f3, f4);
    }

    private int getDimension() {
        if (this.compact) {
            return this.nbLayers * 4 + 11;
        }
        int n2 = this.nbLayers;
        if (n2 <= 4) {
            return n2 * 4 + 15;
        }
        return n2 * 4 + ((n2 - 4) / 8 + 1) * 2 + 15;
    }

    public AztecDetectorResult detect() throws NotFoundException {
        return this.detect(false);
    }

    public AztecDetectorResult detect(boolean bl) throws NotFoundException {
        ResultPoint[] resultPointArray;
        Detector detector = this;
        Object object = detector.getBullsEyeCorners(detector.getMatrixCenter());
        if (bl) {
            ResultPoint[] resultPointArray2 = object;
            ResultPoint[] resultPointArray3 = object;
            resultPointArray = resultPointArray2[0];
            resultPointArray2[0] = resultPointArray3[2];
            resultPointArray3[2] = resultPointArray;
        }
        ResultPoint[] resultPointArray4 = object;
        ResultPoint[] resultPointArray5 = object;
        Detector detector2 = this;
        detector2.extractParameters((ResultPoint[])object);
        resultPointArray = detector2.image;
        int n2 = detector2.shift;
        ResultPoint[] resultPointArray6 = object;
        ResultPoint[] resultPointArray7 = object;
        object = object[n2 % 4];
        ResultPoint resultPoint = resultPointArray7[(n2 + 1) % 4];
        ResultPoint resultPoint2 = resultPointArray6[(n2 + 2) % 4];
        ResultPoint resultPoint3 = resultPointArray5[(n2 + 3) % 4];
        object = this.sampleGrid((BitMatrix)resultPointArray, (ResultPoint)object, resultPoint, resultPoint2, resultPoint3);
        resultPointArray = this.getMatrixCornerPoints(resultPointArray4);
        Detector detector3 = this;
        boolean bl2 = detector3.compact;
        int n3 = detector3.nbDataBlocks;
        int n4 = detector3.nbLayers;
        return new AztecDetectorResult((BitMatrix)object, resultPointArray, bl2, n3, n4);
    }

    static final class Point {
        private final int x;
        private final int y;

        Point(int n2, int n3) {
            this.x = n2;
            this.y = n3;
        }

        ResultPoint toResultPoint() {
            return new ResultPoint(this.getX(), this.getY());
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }

        public String toString() {
            return "<" + this.x + ' ' + this.y + '>';
        }
    }
}

