/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.aztec.encoder.AztecCode;
import com.dcloud.zxing2.aztec.encoder.Encoder;
import com.dcloud.zxing2.common.BitMatrix;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    private static BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Charset charset, int n4, int n5) {
        if (barcodeFormat == BarcodeFormat.AZTEC) {
            return AztecWriter.renderResult(Encoder.encode(string2.getBytes(charset), n4, n5), n2, n3);
        }
        throw new IllegalArgumentException("Can only encode AZTEC, but got " + (Object)((Object)barcodeFormat));
    }

    private static BitMatrix renderResult(AztecCode object, int n2, int n3) {
        if ((object = ((AztecCode)object).getMatrix()) != null) {
            BitMatrix bitMatrix;
            int n4 = n3;
            int n5 = n2;
            Object object2 = object;
            n2 = ((BitMatrix)object2).getWidth();
            n3 = ((BitMatrix)object2).getHeight();
            int n6 = Math.max(n5, n2);
            int n7 = Math.max(n4, n3);
            int n8 = Math.min(n6 / n2, n7 / n3);
            int n9 = (n6 - n2 * n8) / 2;
            int n10 = (n7 - n3 * n8) / 2;
            BitMatrix bitMatrix2 = bitMatrix;
            bitMatrix = new BitMatrix(n6, n7);
            n6 = 0;
            while (n6 < n3) {
                n7 = 0;
                int n11 = n9;
                while (n7 < n2) {
                    if (((BitMatrix)object).get(n7, n6)) {
                        int n12 = n8;
                        bitMatrix2.setRegion(n11, n10, n12, n12);
                    }
                    ++n7;
                    n11 += n8;
                }
                ++n6;
                n10 += n8;
            }
            return bitMatrix2;
        }
        throw new IllegalStateException();
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        Object object = DEFAULT_CHARSET;
        int n4 = 33;
        int n5 = 0;
        if (map != null) {
            EncodeHintType encodeHintType = EncodeHintType.CHARACTER_SET;
            if (map.containsKey((Object)encodeHintType)) {
                object = Charset.forName(map.get((Object)encodeHintType).toString());
            }
            if (map.containsKey((Object)(encodeHintType = EncodeHintType.ERROR_CORRECTION))) {
                n4 = Integer.parseInt(map.get((Object)encodeHintType).toString());
            }
            if (map.containsKey((Object)(encodeHintType = EncodeHintType.AZTEC_LAYERS))) {
                n5 = Integer.parseInt(map.get((Object)encodeHintType).toString());
            }
        }
        return AztecWriter.encode(string2, barcodeFormat, n2, n3, (Charset)object, n4, n5);
    }
}

