/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.LuminanceSource;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private static final int THUMBNAIL_SCALE_FACTOR = 2;
    private final byte[] yuvData;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public PlanarYUVLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        super(n6, n7);
        if (n4 + n6 <= n2 && n5 + n7 <= n3) {
            PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
            planarYUVLuminanceSource.yuvData = byArray;
            planarYUVLuminanceSource.dataWidth = n2;
            planarYUVLuminanceSource.dataHeight = n3;
            planarYUVLuminanceSource.left = n4;
            planarYUVLuminanceSource.top = n5;
            if (bl) {
                this.reverseHorizontal(n6, n7);
            }
            return;
        }
        throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
    }

    private void reverseHorizontal(int n2, int n3) {
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        int n4 = 0;
        int n5 = planarYUVLuminanceSource.top * this.dataWidth + this.left;
        while (n4 < n3) {
            int n6 = n5 + n2 / 2;
            int n7 = n5 + n2 - 1;
            int n8 = n5;
            while (n8 < n6) {
                byte[] byArray2 = byArray;
                byte[] byArray3 = byArray;
                byte by = byArray2[n8];
                byArray2[n8] = byArray3[n7];
                byArray3[n7] = by;
                ++n8;
                --n7;
            }
            ++n4;
            n5 += this.dataWidth;
        }
    }

    @Override
    public byte[] getRow(int n2, byte[] byArray) {
        if (n2 >= 0 && n2 < this.getHeight()) {
            int n3 = this.getWidth();
            if (byArray == null || byArray.length < n3) {
                byArray = new byte[n3];
            }
            int n4 = (n2 + this.top) * this.dataWidth + this.left;
            System.arraycopy(this.yuvData, n4, byArray, 0, n3);
            return byArray;
        }
        throw new IllegalArgumentException("Requested row is outside the image: " + n2);
    }

    @Override
    public byte[] getMatrix() {
        int n2 = this.getWidth();
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        int n3 = planarYUVLuminanceSource.getHeight();
        int n4 = planarYUVLuminanceSource.dataWidth;
        if (n2 == n4 && n3 == this.dataHeight) {
            return this.yuvData;
        }
        int n5 = n4;
        int n6 = n2 * n3;
        byte[] byArray = new byte[n6];
        n4 = this.top * n4 + this.left;
        if (n2 == n5) {
            System.arraycopy(this.yuvData, n4, byArray, 0, n6);
            return byArray;
        }
        byte[] byArray2 = this.yuvData;
        for (int i2 = 0; i2 < n3; ++i2) {
            System.arraycopy(byArray2, n4, byArray, i2 * n2, n2);
            n4 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        int n6 = planarYUVLuminanceSource.dataWidth;
        int n7 = planarYUVLuminanceSource.dataHeight;
        PlanarYUVLuminanceSource planarYUVLuminanceSource2 = this;
        int n8 = planarYUVLuminanceSource2.left + n2;
        n2 = planarYUVLuminanceSource2.top + n3;
        return new PlanarYUVLuminanceSource(byArray, n6, n7, n8, n2, n4, n5, false);
    }

    public int[] renderThumbnail() {
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        int n2 = planarYUVLuminanceSource.getWidth() / 2;
        int n3 = this.getHeight() / 2;
        int[] nArray = new int[n2 * n3];
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        int n4 = planarYUVLuminanceSource.top * this.dataWidth + this.left;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = i2 * n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = n5 + i3;
                nArray[n6] = (byArray[n4 + i3 * 2] & 0xFF) * 65793 | 0xFF000000;
            }
            n4 += this.dataWidth * 2;
        }
        return nArray;
    }

    public int getThumbnailWidth() {
        return this.getWidth() / 2;
    }

    public int getThumbnailHeight() {
        return this.getHeight() / 2;
    }
}

