/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.ReaderException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.aztec.AztecReader;
import com.dcloud.zxing2.datamatrix.DataMatrixReader;
import com.dcloud.zxing2.maxicode.MaxiCodeReader;
import com.dcloud.zxing2.oned.MultiFormatOneDReader;
import com.dcloud.zxing2.pdf417.PDF417Reader;
import com.dcloud.zxing2.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatReader
implements Reader {
    private Map<DecodeHintType, ?> hints;
    private Reader[] readers;

    private Result decodeInternal(BinaryBitmap binaryBitmap) throws NotFoundException {
        Reader[] readerArray = this.readers;
        if (this.readers != null) {
            int n2 = readerArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    return readerArray[i2].decode(binaryBitmap, this.hints);
                }
                catch (ReaderException readerException) {
                    continue;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException {
        this.setHints(null);
        return this.decodeInternal(binaryBitmap);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException {
        this.setHints(map);
        return this.decodeInternal(binaryBitmap);
    }

    public Result decodeWithState(BinaryBitmap binaryBitmap) throws NotFoundException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(binaryBitmap);
    }

    public void setHints(Map<DecodeHintType, ?> map) {
        ArrayList<Object> arrayList;
        this.hints = map;
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        Object object = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>();
        if (object != null) {
            Reader reader;
            boolean bl2 = object.contains((Object)BarcodeFormat.UPC_A) || object.contains((Object)BarcodeFormat.UPC_E) || object.contains((Object)BarcodeFormat.EAN_13) || object.contains((Object)BarcodeFormat.EAN_8) || object.contains((Object)BarcodeFormat.CODABAR) || object.contains((Object)BarcodeFormat.CODE_39) || object.contains((Object)BarcodeFormat.CODE_93) || object.contains((Object)BarcodeFormat.CODE_128) || object.contains((Object)BarcodeFormat.ITF) || object.contains((Object)BarcodeFormat.RSS_14) || object.contains((Object)BarcodeFormat.RSS_EXPANDED);
            if (bl2 && !bl) {
                MultiFormatOneDReader multiFormatOneDReader;
                reader = multiFormatOneDReader;
                multiFormatOneDReader = new MultiFormatOneDReader(map);
                arrayList2.add(reader);
            }
            if (object.contains((Object)BarcodeFormat.QR_CODE)) {
                QRCodeReader qRCodeReader;
                reader = qRCodeReader;
                qRCodeReader = new QRCodeReader();
                arrayList2.add(reader);
            }
            if (object.contains((Object)BarcodeFormat.DATA_MATRIX)) {
                DataMatrixReader dataMatrixReader;
                reader = dataMatrixReader;
                dataMatrixReader = new DataMatrixReader();
                arrayList2.add(reader);
            }
            if (object.contains((Object)BarcodeFormat.AZTEC)) {
                AztecReader aztecReader;
                reader = aztecReader;
                aztecReader = new AztecReader();
                arrayList2.add(reader);
            }
            if (object.contains((Object)BarcodeFormat.PDF_417)) {
                PDF417Reader pDF417Reader;
                reader = pDF417Reader;
                pDF417Reader = new PDF417Reader();
                arrayList2.add(reader);
            }
            if (object.contains((Object)BarcodeFormat.MAXICODE)) {
                MaxiCodeReader maxiCodeReader;
                object = maxiCodeReader;
                maxiCodeReader = new MaxiCodeReader();
                arrayList2.add(object);
            }
            if (bl2 && bl) {
                MultiFormatOneDReader multiFormatOneDReader;
                object = multiFormatOneDReader;
                multiFormatOneDReader = new MultiFormatOneDReader(map);
                arrayList2.add(object);
            }
        }
        if (arrayList2.isEmpty()) {
            MaxiCodeReader maxiCodeReader;
            PDF417Reader pDF417Reader;
            AztecReader aztecReader;
            DataMatrixReader dataMatrixReader;
            QRCodeReader qRCodeReader;
            if (!bl) {
                MultiFormatOneDReader multiFormatOneDReader;
                object = multiFormatOneDReader;
                multiFormatOneDReader = new MultiFormatOneDReader(map);
                arrayList2.add(object);
            }
            ArrayList<Object> arrayList3 = arrayList2;
            Reader reader = qRCodeReader;
            qRCodeReader = new QRCodeReader();
            arrayList3.add(reader);
            reader = dataMatrixReader;
            dataMatrixReader = new DataMatrixReader();
            arrayList3.add(reader);
            reader = aztecReader;
            aztecReader = new AztecReader();
            arrayList3.add(reader);
            reader = pDF417Reader;
            pDF417Reader = new PDF417Reader();
            arrayList3.add(reader);
            reader = maxiCodeReader;
            maxiCodeReader = new MaxiCodeReader();
            arrayList3.add(reader);
            if (bl) {
                MultiFormatOneDReader multiFormatOneDReader;
                reader = multiFormatOneDReader;
                multiFormatOneDReader = new MultiFormatOneDReader(map);
                arrayList2.add(reader);
            }
        }
        ArrayList<Object> arrayList4 = arrayList2;
        this.readers = arrayList4.toArray(new Reader[arrayList4.size()]);
    }

    @Override
    public void reset() {
        Reader[] readerArray = readerArray.readers;
        if (readerArray.readers != null) {
            int n2 = readerArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                readerArray[i2].reset();
            }
        }
    }
}

