/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget.photoview;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.dcloud.android.widget.photoview.OnGestureListener;
import com.dcloud.android.widget.photoview.Util;

class CustomGestureDetector {
    private static final int INVALID_POINTER_ID = -1;
    private int mActivePointerId;
    private int mActivePointerIndex;
    private final ScaleGestureDetector mDetector;
    private VelocityTracker mVelocityTracker;
    private boolean mIsDragging;
    private float mLastTouchX;
    private float mLastTouchY;
    private final float mTouchSlop;
    private final float mMinimumVelocity;
    private OnGestureListener mListener;

    CustomGestureDetector(Context context, OnGestureListener object) {
        ScaleGestureDetector.OnScaleGestureListener onScaleGestureListener;
        CustomGestureDetector customGestureDetector = this;
        OnGestureListener onGestureListener = object;
        CustomGestureDetector customGestureDetector2 = this;
        this.mActivePointerId = -1;
        this.mActivePointerIndex = 0;
        object = ViewConfiguration.get((Context)context);
        customGestureDetector2.mMinimumVelocity = object.getScaledMinimumFlingVelocity();
        customGestureDetector2.mTouchSlop = object.getScaledTouchSlop();
        customGestureDetector.mListener = onGestureListener;
        object = onScaleGestureListener;
        onScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                float f2 = scaleGestureDetector.getScaleFactor();
                if (!Float.isNaN(f2) && !Float.isInfinite(f2)) {
                    ScaleGestureDetector scaleGestureDetector2 = scaleGestureDetector;
                    float f3 = scaleGestureDetector2.getFocusX();
                    CustomGestureDetector.this.mListener.onScale(f2, f3, scaleGestureDetector2.getFocusY());
                    return true;
                }
                return false;
            }

            public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            }
        };
        customGestureDetector.mDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)object);
    }

    private float getActiveX(MotionEvent motionEvent) {
        try {
            return motionEvent.getX(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getX();
        }
    }

    private float getActiveY(MotionEvent motionEvent) {
        try {
            return motionEvent.getY(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getY();
        }
    }

    private boolean processTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction() & 0xFF) {
            default: {
                break;
            }
            case 6: {
                MotionEvent motionEvent2 = motionEvent;
                int n2 = Util.getPointerIndex(motionEvent2.getAction());
                if (motionEvent2.getPointerId(n2) != this.mActivePointerId) break;
                n2 = n2 == 0 ? 1 : 0;
                this.mActivePointerId = motionEvent.getPointerId(n2);
                this.mLastTouchX = motionEvent.getX(n2);
                this.mLastTouchY = motionEvent.getY(n2);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 2: {
                CustomGestureDetector customGestureDetector = this;
                float f2 = this.getActiveX(motionEvent);
                float f3 = customGestureDetector.getActiveY(motionEvent);
                float f4 = f2 - this.mLastTouchX;
                float f5 = f3 - this.mLastTouchY;
                if (!customGestureDetector.mIsDragging) {
                    float f6 = f4;
                    float f7 = f5;
                    boolean bl = Math.sqrt(f6 * f6 + f7 * f7) >= (double)this.mTouchSlop;
                    this.mIsDragging = bl;
                }
                if (!this.mIsDragging) break;
                this.mListener.onDrag(f4, f5);
                this.mLastTouchX = f2;
                this.mLastTouchY = f3;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.addMovement(motionEvent);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker;
                this.mActivePointerId = -1;
                if (this.mIsDragging && this.mVelocityTracker != null) {
                    float f8;
                    CustomGestureDetector customGestureDetector = this;
                    this.mLastTouchX = this.getActiveX(motionEvent);
                    customGestureDetector.mLastTouchY = customGestureDetector.getActiveY(motionEvent);
                    customGestureDetector.mVelocityTracker.addMovement(motionEvent);
                    customGestureDetector.mVelocityTracker.computeCurrentVelocity(1000);
                    float f9 = customGestureDetector.mVelocityTracker.getXVelocity();
                    float f10 = this.mVelocityTracker.getYVelocity();
                    if (Math.max(Math.abs(f8), Math.abs(f10)) >= this.mMinimumVelocity) {
                        float f11 = f10;
                        float f12 = f9;
                        CustomGestureDetector customGestureDetector2 = this;
                        f9 = customGestureDetector2.mLastTouchX;
                        f10 = customGestureDetector2.mLastTouchY;
                        float f13 = -f12;
                        float f14 = -f11;
                        this.mListener.onFling(f9, f10, f13, f14);
                    }
                }
                if ((velocityTracker = this.mVelocityTracker) == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 0: {
                VelocityTracker velocityTracker;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
                if (velocityTracker != null) {
                    velocityTracker.addMovement(motionEvent);
                }
                this.mLastTouchX = this.getActiveX(motionEvent);
                this.mLastTouchY = this.getActiveY(motionEvent);
                this.mIsDragging = false;
            }
        }
        int n3 = this.mActivePointerId;
        if (n3 == -1) {
            n3 = 0;
        }
        this.mActivePointerIndex = motionEvent.findPointerIndex(n3);
        return true;
    }

    public boolean isScaling() {
        return this.mDetector.isInProgress();
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2;
        CustomGestureDetector customGestureDetector;
        try {
            customGestureDetector = this;
            motionEvent2 = motionEvent;
            this.mDetector.onTouchEvent(motionEvent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return customGestureDetector.processTouchEvent(motionEvent2);
    }
}

