/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import com.dcloud.android.annotation.IntDef;
import com.dcloud.android.annotation.NonNull;
import com.dcloud.android.v4.view.animation.FastOutSlowInInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class MaterialProgressDrawable
extends Drawable
implements Animatable {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final float FULL_ROTATION = 1080.0f;
    public static final int LARGE = 0;
    public static final int DEFAULT = 1;
    private static final int CIRCLE_DIAMETER = 40;
    private static final float CENTER_RADIUS = 8.75f;
    private static final float STROKE_WIDTH = 2.5f;
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final float CENTER_RADIUS_LARGE = 12.5f;
    private static final float STROKE_WIDTH_LARGE = 3.0f;
    private static final float COLOR_START_DELAY_OFFSET = 0.75f;
    private static final float END_TRIM_START_DELAY_OFFSET = 0.5f;
    private static final float START_TRIM_DURATION_OFFSET = 0.5f;
    private static final int ANIMATION_DURATION = 1332;
    private static final float NUM_POINTS = 5.0f;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 5;
    private static final float ARROW_OFFSET_ANGLE = 5.0f;
    private static final int ARROW_WIDTH_LARGE = 12;
    private static final int ARROW_HEIGHT_LARGE = 6;
    private static final float MAX_PROGRESS_ARC = 0.8f;
    private final int[] COLORS;
    private final ArrayList<Animation> mAnimators;
    private final Ring mRing;
    private float mRotation;
    private Resources mResources;
    private View mParent;
    private Animation mAnimation;
    private float mRotationCount;
    private double mWidth;
    private double mHeight;
    boolean mFinishing;
    private final Drawable.Callback mCallback;

    public MaterialProgressDrawable(Context object, View object2) {
        Ring ring;
        Ring ring2;
        Drawable.Callback callback;
        MaterialProgressDrawable materialProgressDrawable = this;
        Context context = object;
        View view = object2;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = -16777216;
        this.COLORS = nArray;
        this.mAnimators = new ArrayList();
        object2 = callback;
        this.mCallback = new Drawable.Callback(){

            public void invalidateDrawable(Drawable drawable2) {
                MaterialProgressDrawable.this.invalidateSelf();
            }

            public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l2) {
                MaterialProgressDrawable.this.scheduleSelf(runnable, l2);
            }

            public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
                MaterialProgressDrawable.this.unscheduleSelf(runnable);
            }
        };
        this.mParent = view;
        materialProgressDrawable.mResources = context.getResources();
        Ring ring3 = ring2 = ring;
        ring3((Drawable.Callback)object2);
        this.mRing = ring3;
        ring.setColors((int[])object);
        materialProgressDrawable.updateSizes(1);
        materialProgressDrawable.setupAnimators();
    }

    private void setSizeParameters(double d2, double d3, double d4, double d5, float f2, float f3) {
        Ring ring;
        Ring ring2 = ring = this.mRing;
        float f4 = this.mResources.getDisplayMetrics().density;
        double d6 = f4;
        this.mWidth = d2 * d6;
        this.mHeight = d3 * d6;
        ring.setStrokeWidth((float)d5 * f4);
        ring2.setCenterRadius(d4 * d6);
        ring2.setColorIndex(0);
        float f5 = f2 * f4;
        ring.setArrowDimensions(f5, f3 * f4);
        ring.setInsets((int)this.mWidth, (int)this.mHeight);
    }

    private float getRotation() {
        return this.mRotation;
    }

    private float getMinProgressArc(Ring ring) {
        return (float)Math.toRadians((double)ring.getStrokeWidth() / (ring.getCenterRadius() * (Math.PI * 2)));
    }

    private int evaluateColorChange(float f2, int n2, int n3) {
        int n4 = n2;
        int n5 = n4 >> 24 & 0xFF;
        n2 = n5;
        int n6 = n3;
        int n7 = n4;
        n4 = n7 >> 16 & 0xFF;
        n3 = n7 >> 8 & 0xFF;
        int n8 = n7 & 0xFF;
        int n9 = n6;
        int n10 = n9;
        int n11 = n2;
        int n12 = n10;
        n2 = n12 >> 16 & 0xFF;
        n10 = n12 >> 8 & 0xFF;
        int n13 = n12 & 0xFF;
        return n5 + (int)(f2 * (float)((n9 >> 24 & 0xFF) - n11)) << 24 | n4 + (int)(f2 * (float)(n2 - n4)) << 16 | n3 + (int)(f2 * (float)(n10 - n3)) << 8 | n8 + (int)(f2 * (float)(n13 - n8));
    }

    private void updateRingColor(float f2, Ring ring) {
        if (f2 > 0.75f) {
            Ring ring2 = ring;
            float f3 = (f2 - 0.75f) / 0.25f;
            int n2 = ring2.getStartingColor();
            int n3 = ring2.getNextColor();
            ring.setColor(this.evaluateColorChange(f3, n2, n3));
        }
    }

    private void applyFinishTranslation(float f2, Ring ring) {
        Ring ring2 = ring;
        Ring ring3 = ring;
        this.updateRingColor(f2, ring);
        float f3 = (float)(Math.floor(ring3.getStartingRotation() / 0.8f) + 1.0);
        float f4 = this.getMinProgressArc(ring3);
        ring2.setStartTrim(ring2.getStartingStartTrim() + (ring.getStartingEndTrim() - f4 - ring.getStartingStartTrim()) * f2);
        ring2.setEndTrim(ring2.getStartingEndTrim());
        ring2.setRotation(ring2.getStartingRotation() + (f3 - ring.getStartingRotation()) * f2);
    }

    private void setupAnimators() {
        final Ring ring = this.mRing;
        Animation animation = new Animation(){

            public void applyTransformation(float f2, Transformation object) {
                object = MaterialProgressDrawable.this;
                if (object.mFinishing) {
                    ((MaterialProgressDrawable)((Object)object)).applyFinishTranslation(f2, ring);
                } else {
                    1 v0 = this;
                    float f3 = ((MaterialProgressDrawable)((Object)object)).getMinProgressArc(ring);
                    float f4 = v0.ring.getStartingEndTrim();
                    float f5 = v0.ring.getStartingStartTrim();
                    float f6 = v0.ring.getStartingRotation();
                    v0.MaterialProgressDrawable.this.updateRingColor(f2, ring);
                    if (f2 <= 0.5f) {
                        float f7 = f5;
                        f5 = f2 / 0.5f;
                        f5 = f7 + (0.8f - f3) * MATERIAL_INTERPOLATOR.getInterpolation(f5);
                        ring.setStartTrim(f5);
                    }
                    if (f2 > 0.5f) {
                        f3 = f4 + (0.8f - f3) * MATERIAL_INTERPOLATOR.getInterpolation((f2 - 0.5f) / 0.5f);
                        ring.setEndTrim(f3);
                    }
                    float f8 = f2;
                    f2 = f6 + f2 * 0.25f;
                    ring.setRotation(f2);
                    float f9 = f8 * 216.0f + MaterialProgressDrawable.this.mRotationCount / 5.0f * 1080.0f;
                    MaterialProgressDrawable.this.setRotation(f9);
                }
            }
        };
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        animation.setInterpolator(LINEAR_INTERPOLATOR);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                MaterialProgressDrawable.access$402(MaterialProgressDrawable.this, 0.0f);
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
                2 v0 = this;
                v0.ring.storeOriginals();
                v0.ring.goToNextColor();
                Ring ring2 = v0.ring;
                ring2.setStartTrim(ring2.getEndTrim());
                MaterialProgressDrawable materialProgressDrawable = v0.MaterialProgressDrawable.this;
                if (materialProgressDrawable.mFinishing) {
                    materialProgressDrawable.mFinishing = false;
                    animation.setDuration(1332L);
                    ring.setShowArrow(false);
                } else {
                    MaterialProgressDrawable materialProgressDrawable2 = materialProgressDrawable;
                    MaterialProgressDrawable.access$402(materialProgressDrawable2, (materialProgressDrawable2.mRotationCount + 1.0f) % 5.0f);
                }
            }
        });
        this.mAnimation = animation;
    }

    static /* synthetic */ float access$402(MaterialProgressDrawable materialProgressDrawable, float f2) {
        materialProgressDrawable.mRotationCount = f2;
        return f2;
    }

    public void updateSizes(@ProgressDrawableSize int n2) {
        if (n2 == 0) {
            this.setSizeParameters(56.0, 56.0, 12.5, 3.0, 12.0f, 6.0f);
        } else {
            this.setSizeParameters(40.0, 40.0, 8.75, 2.5, 10.0f, 5.0f);
        }
    }

    public void showArrow(boolean bl) {
        this.mRing.setShowArrow(bl);
    }

    public void setArrowScale(float f2) {
        this.mRing.setArrowScale(f2);
    }

    public void setStartEndTrim(float f2, float f3) {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mRing.setStartTrim(f2);
        materialProgressDrawable.mRing.setEndTrim(f3);
    }

    public void setProgressRotation(float f2) {
        this.mRing.setRotation(f2);
    }

    public void setBackgroundColor(int n2) {
        this.mRing.setBackgroundColor(n2);
    }

    public void setColorSchemeColors(int ... nArray) {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mRing.setColors(nArray);
        materialProgressDrawable.mRing.setColorIndex(0);
    }

    public int getIntrinsicHeight() {
        return (int)this.mHeight;
    }

    public int getIntrinsicWidth() {
        return (int)this.mWidth;
    }

    public void draw(Canvas canvas) {
        Canvas canvas2 = canvas;
        Rect rect = this.getBounds();
        int n2 = canvas.save();
        float f2 = this.mRotation;
        float f3 = rect.exactCenterX();
        float f4 = rect.exactCenterY();
        canvas2.rotate(f2, f3, f4);
        this.mRing.draw(canvas, rect);
        canvas2.restoreToCount(n2);
    }

    public void setAlpha(int n2) {
        this.mRing.setAlpha(n2);
    }

    public int getAlpha() {
        return this.mRing.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mRing.setColorFilter(colorFilter);
    }

    void setRotation(float f2) {
        this.mRotation = f2;
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isRunning() {
        ArrayList<Animation> arrayList = ((MaterialProgressDrawable)((Object)arrayList)).mAnimators;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Animation animation = (Animation)arrayList.get(i2);
            if (!animation.hasStarted() || animation.hasEnded()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mAnimation.reset();
        materialProgressDrawable.mRing.storeOriginals();
        if (materialProgressDrawable.mRing.getEndTrim() != this.mRing.getStartTrim()) {
            MaterialProgressDrawable materialProgressDrawable2 = this;
            materialProgressDrawable2.mFinishing = true;
            materialProgressDrawable2.mAnimation.setDuration(666L);
            materialProgressDrawable2.mParent.startAnimation(this.mAnimation);
        } else {
            MaterialProgressDrawable materialProgressDrawable3 = this;
            materialProgressDrawable3.mRing.setColorIndex(0);
            materialProgressDrawable3.mRing.resetOriginals();
            materialProgressDrawable3.mAnimation.setDuration(1332L);
            materialProgressDrawable3.mParent.startAnimation(this.mAnimation);
        }
    }

    public void stop() {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mParent.clearAnimation();
        materialProgressDrawable.setRotation(0.0f);
        materialProgressDrawable.mRing.setShowArrow(false);
        materialProgressDrawable.mRing.setColorIndex(0);
        materialProgressDrawable.mRing.resetOriginals();
    }

    private static class Ring {
        private final RectF mTempBounds = new RectF();
        private final Paint mPaint;
        private final Paint mArrowPaint;
        private final Drawable.Callback mCallback;
        private float mStartTrim;
        private float mEndTrim;
        private float mRotation;
        private float mStrokeWidth;
        private float mStrokeInset;
        private int[] mColors;
        private int mColorIndex;
        private float mStartingStartTrim;
        private float mStartingEndTrim;
        private float mStartingRotation;
        private boolean mShowArrow;
        private Path mArrow;
        private float mArrowScale;
        private double mRingCenterRadius;
        private int mArrowWidth;
        private int mArrowHeight;
        private int mAlpha;
        private final Paint mCirclePaint;
        private int mBackgroundColor;
        private int mCurrentColor;

        public Ring(Drawable.Callback callback) {
            Paint paint;
            Paint paint2;
            Paint paint3 = paint2;
            this.mPaint = new Paint();
            Paint paint4 = paint;
            Paint paint5 = paint3;
            Ring ring = this;
            Paint paint6 = paint4;
            paint6();
            ring.mArrowPaint = paint6;
            ring.mStartTrim = 0.0f;
            ring.mEndTrim = 0.0f;
            ring.mRotation = 0.0f;
            ring.mStrokeWidth = 5.0f;
            ring.mStrokeInset = 2.5f;
            ring.mCirclePaint = new Paint(1);
            this.mCallback = callback;
            paint5.setStrokeCap(Paint.Cap.SQUARE);
            paint5.setAntiAlias(true);
            paint5.setStyle(Paint.Style.STROKE);
            paint.setStyle(Paint.Style.FILL);
            paint.setAntiAlias(true);
        }

        private void drawTriangle(Canvas canvas, float f2, float f3, Rect rect) {
            if (this.mShowArrow) {
                Path path = this.mArrow;
                if (path == null) {
                    this.mArrow = new Path();
                    this.mArrow.setFillType(Path.FillType.EVEN_ODD);
                } else {
                    path.reset();
                }
                Ring ring = this;
                Rect rect2 = rect;
                float f4 = f2;
                float f5 = f3;
                Ring ring2 = this;
                float f6 = (float)((int)ring2.mStrokeInset / 2) * this.mArrowScale;
                f2 = (float)(ring2.mRingCenterRadius * Math.cos(0.0) + (double)rect.exactCenterX());
                f3 = (float)(ring2.mRingCenterRadius * Math.sin(0.0) + (double)rect.exactCenterY());
                ring2.mArrow.moveTo(0.0f, 0.0f);
                ring2.mArrow.lineTo((float)this.mArrowWidth * this.mArrowScale, 0.0f);
                float f7 = this.mArrowScale;
                ring2.mArrow.lineTo((float)this.mArrowWidth * f7 / 2.0f, (float)this.mArrowHeight * f7);
                ring2.mArrow.offset(f2 - f6, f3);
                ring2.mArrow.close();
                ring2.mArrowPaint.setColor(this.mCurrentColor);
                float f8 = f4 + f5 - 5.0f;
                f6 = rect2.exactCenterX();
                f2 = rect2.exactCenterY();
                canvas.rotate(f8, f6, f2);
                Path path2 = ring.mArrow;
                canvas.drawPath(path2, ring.mArrowPaint);
            }
        }

        private int getNextColorIndex() {
            return (this.mColorIndex + 1) % this.mColors.length;
        }

        private void invalidateSelf() {
            this.mCallback.invalidateDrawable(null);
        }

        public void setBackgroundColor(int n2) {
            this.mBackgroundColor = n2;
        }

        public void setArrowDimensions(float f2, float f3) {
            this.mArrowWidth = (int)f2;
            this.mArrowHeight = (int)f3;
        }

        public void draw(Canvas canvas, Rect rect) {
            Ring ring = this;
            Canvas canvas2 = canvas;
            Ring ring2 = this;
            RectF rectF = ring2.mTempBounds;
            rectF.set(rect);
            float f2 = this.mStrokeInset;
            rectF.inset(f2, f2);
            float f3 = this.mRotation;
            float f4 = (ring2.mStartTrim + f3) * 360.0f;
            f3 = (ring2.mEndTrim + f3) * 360.0f - f4;
            ring2.mPaint.setColor(this.mCurrentColor);
            Paint paint = ring2.mPaint;
            canvas2.drawArc(rectF, f4, f3, false, paint);
            ring.drawTriangle(canvas2, f4, f3, rect);
            if (ring.mAlpha < 255) {
                Rect rect2 = rect;
                Ring ring3 = this;
                ring3.mCirclePaint.setColor(this.mBackgroundColor);
                ring3.mCirclePaint.setAlpha(255 - this.mAlpha);
                float f5 = rect2.exactCenterX();
                float f6 = rect2.exactCenterY();
                float f7 = rect2.width() / 2;
                rectF = this.mCirclePaint;
                canvas.drawCircle(f5, f6, f7, (Paint)rectF);
            }
        }

        public void setColors(@NonNull int[] nArray) {
            this.mColors = nArray;
            this.setColorIndex(0);
        }

        public void setColor(int n2) {
            this.mCurrentColor = n2;
        }

        public void setColorIndex(int n2) {
            this.mColorIndex = n2;
            this.mCurrentColor = this.mColors[n2];
        }

        public int getNextColor() {
            return this.mColors[this.getNextColorIndex()];
        }

        public void goToNextColor() {
            Ring ring = this;
            ring.setColorIndex(ring.getNextColorIndex());
        }

        public void setColorFilter(ColorFilter colorFilter) {
            Ring ring = this;
            ring.mPaint.setColorFilter(colorFilter);
            ring.invalidateSelf();
        }

        public void setAlpha(int n2) {
            this.mAlpha = n2;
        }

        public int getAlpha() {
            return this.mAlpha;
        }

        public void setStrokeWidth(float f2) {
            Ring ring = this;
            ring.mStrokeWidth = f2;
            ring.mPaint.setStrokeWidth(f2);
            ring.invalidateSelf();
        }

        public float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        public void setStartTrim(float f2) {
            this.mStartTrim = f2;
            this.invalidateSelf();
        }

        public float getStartTrim() {
            return this.mStartTrim;
        }

        public float getStartingStartTrim() {
            return this.mStartingStartTrim;
        }

        public float getStartingEndTrim() {
            return this.mStartingEndTrim;
        }

        public int getStartingColor() {
            return this.mColors[this.mColorIndex];
        }

        public void setEndTrim(float f2) {
            this.mEndTrim = f2;
            this.invalidateSelf();
        }

        public float getEndTrim() {
            return this.mEndTrim;
        }

        public void setRotation(float f2) {
            this.mRotation = f2;
            this.invalidateSelf();
        }

        public float getRotation() {
            return this.mRotation;
        }

        public void setInsets(int n2, int n3) {
            float f2 = Math.min(n2, n3);
            double d2 = this.mRingCenterRadius;
            f2 = !(d2 <= 0.0) && !(f2 < 0.0f) ? (float)((double)(f2 / 2.0f) - d2) : (float)Math.ceil(this.mStrokeWidth / 2.0f);
            this.mStrokeInset = f2;
        }

        public float getInsets() {
            return this.mStrokeInset;
        }

        public void setCenterRadius(double d2) {
            this.mRingCenterRadius = d2;
        }

        public double getCenterRadius() {
            return this.mRingCenterRadius;
        }

        public void setShowArrow(boolean bl) {
            if (this.mShowArrow != bl) {
                this.mShowArrow = bl;
                this.invalidateSelf();
            }
        }

        public void setArrowScale(float f2) {
            if (f2 != this.mArrowScale) {
                this.mArrowScale = f2;
                this.invalidateSelf();
            }
        }

        public float getStartingRotation() {
            return this.mStartingRotation;
        }

        public void storeOriginals() {
            Ring ring = this;
            ring.mStartingStartTrim = ring.mStartTrim;
            ring.mStartingEndTrim = ring.mEndTrim;
            ring.mStartingRotation = ring.mRotation;
        }

        public void resetOriginals() {
            Ring ring = this;
            ring.mStartingStartTrim = 0.0f;
            ring.mStartingEndTrim = 0.0f;
            ring.mStartingRotation = 0.0f;
            ring.setStartTrim(0.0f);
            ring.setEndTrim(0.0f);
            ring.setRotation(0.0f);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @IntDef(value={0L, 1L})
    public static @interface ProgressDrawableSize {
    }
}

