/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.view.animation;

import android.view.animation.Interpolator;

abstract class LookupTableInterpolator
implements Interpolator {
    private final float[] mValues;
    private final float mStepSize;

    public LookupTableInterpolator(float[] fArray) {
        this.mValues = fArray;
        this.mStepSize = 1.0f / (float)(fArray.length - 1);
    }

    public float getInterpolation(float f2) {
        if (f2 >= 1.0f) {
            return 1.0f;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        float f3 = f2;
        float[] fArray = this.mValues;
        int n2 = Math.min((int)(f3 * (float)(this.mValues.length - 1)), fArray.length - 2);
        float f4 = this.mStepSize;
        f4 = (f3 - (float)n2 * f4) / f4;
        float[] fArray2 = this.mValues;
        return this.mValues[n2] + f4 * (fArray2[n2 + 1] - fArray2[n2]);
    }
}

