/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.view;

import android.view.View;
import android.view.ViewParent;
import com.dcloud.android.v4.view.ViewCompat;
import com.dcloud.android.v4.view.ViewParentCompat;

public class NestedScrollingChildHelper {
    private final View mView;
    private ViewParent mNestedScrollingParent;
    private boolean mIsNestedScrollingEnabled;
    private int[] mTempNestedScrollConsumed;

    public NestedScrollingChildHelper(View view) {
        this.mView = view;
    }

    public void setNestedScrollingEnabled(boolean bl) {
        if (this.mIsNestedScrollingEnabled) {
            ViewCompat.stopNestedScroll(this.mView);
        }
        this.mIsNestedScrollingEnabled = bl;
    }

    public boolean isNestedScrollingEnabled() {
        return this.mIsNestedScrollingEnabled;
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingParent != null;
    }

    public boolean startNestedScroll(int n2) {
        if (this.hasNestedScrollingParent()) {
            return true;
        }
        if (this.isNestedScrollingEnabled()) {
            View view = this.mView;
            for (ViewParent viewParent = (v960717).mView.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
                if (ViewParentCompat.onStartNestedScroll(viewParent, view, this.mView, n2)) {
                    this.mNestedScrollingParent = viewParent;
                    ViewParentCompat.onNestedScrollAccepted(viewParent, view, this.mView, n2);
                    return true;
                }
                if (!(viewParent instanceof View)) continue;
                view = (View)viewParent;
            }
        }
        return false;
    }

    public void stopNestedScroll() {
        ViewParent viewParent = this.mNestedScrollingParent;
        if (viewParent != null) {
            ViewParentCompat.onStopNestedScroll(viewParent, this.mView);
            this.mNestedScrollingParent = null;
        }
    }

    public boolean dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray) {
        if (this.isNestedScrollingEnabled() && this.mNestedScrollingParent != null) {
            if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
                if (nArray != null) {
                    nArray[0] = 0;
                    nArray[1] = 0;
                }
            } else {
                int n6 = 0;
                int n7 = 0;
                if (nArray != null) {
                    this.mView.getLocationInWindow(nArray);
                    n6 = nArray[0];
                    n7 = nArray[1];
                }
                ViewParentCompat.onNestedScroll(this.mNestedScrollingParent, this.mView, n2, n3, n4, n5);
                if (nArray != null) {
                    int[] nArray2 = nArray;
                    this.mView.getLocationInWindow(nArray);
                    nArray2[0] = nArray[0] - n6;
                    nArray2[1] = nArray[1] - n7;
                }
                return true;
            }
        }
        return false;
    }

    public boolean dispatchNestedPreScroll(int n2, int n3, int[] nArray, int[] nArray2) {
        if (this.isNestedScrollingEnabled() && this.mNestedScrollingParent != null) {
            if (n2 == 0 && n3 == 0) {
                if (nArray2 != null) {
                    nArray2[0] = 0;
                    nArray2[1] = 0;
                }
            } else {
                int n4 = 0;
                int n5 = 0;
                if (nArray2 != null) {
                    this.mView.getLocationInWindow(nArray2);
                    n4 = nArray2[0];
                    n5 = nArray2[1];
                }
                if (nArray == null) {
                    if (this.mTempNestedScrollConsumed == null) {
                        this.mTempNestedScrollConsumed = new int[2];
                    }
                    nArray = this.mTempNestedScrollConsumed;
                }
                nArray[0] = 0;
                nArray[1] = 0;
                ViewParentCompat.onNestedPreScroll(this.mNestedScrollingParent, this.mView, n2, n3, nArray);
                if (nArray2 != null) {
                    int[] nArray3 = nArray2;
                    this.mView.getLocationInWindow(nArray2);
                    nArray3[0] = nArray2[0] - n4;
                    nArray3[1] = nArray2[1] - n5;
                }
                return nArray[0] != 0 || nArray[1] != 0;
            }
        }
        return false;
    }

    public boolean dispatchNestedFling(float f2, float f3, boolean bl) {
        ViewParent viewParent;
        if (this.isNestedScrollingEnabled() && (viewParent = this.mNestedScrollingParent) != null) {
            return ViewParentCompat.onNestedFling(viewParent, this.mView, f2, f3, bl);
        }
        return false;
    }

    public boolean dispatchNestedPreFling(float f2, float f3) {
        ViewParent viewParent;
        if (this.isNestedScrollingEnabled() && (viewParent = this.mNestedScrollingParent) != null) {
            return ViewParentCompat.onNestedPreFling(viewParent, this.mView, f2, f3);
        }
        return false;
    }

    public void onDetachedFromWindow() {
        ViewCompat.stopNestedScroll(this.mView);
    }

    public void onStopNestedScroll(View view) {
        ViewCompat.stopNestedScroll(this.mView);
    }
}

