/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.db.DefaultDownloadHelper;
import com.dcloud.android.downloader.db.DownloadDBController;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import java.util.ArrayList;
import java.util.List;

public final class DefaultDownloadDBController
implements DownloadDBController {
    public static final String[] DOWNLOAD_INFO_COLUMNS = new String[]{"_id", "supportRanges", "createAt", "uri", "location", "path", "size", "progress", "status"};
    public static final String[] DOWNLOAD_THREAD_INFO_COLUMNS = new String[]{"_id", "threadId", "downloadInfoId", "uri", "start", "end", "progress"};
    public static final String SQL_UPDATE_DOWNLOAD_THREAD_INFO;
    public static final String SQL_UPDATE_DOWNLOAD_INFO;
    public static final String SQL_UPDATE_DOWNLOADING_INFO_STATUS;
    private final Context context;
    private final DefaultDownloadHelper dbHelper;
    private final SQLiteDatabase writableDatabase;
    private final SQLiteDatabase readableDatabase;

    public DefaultDownloadDBController(Context context, Config config) {
        DefaultDownloadHelper defaultDownloadHelper;
        DefaultDownloadDBController defaultDownloadDBController = object;
        defaultDownloadDBController.context = context;
        Object object = defaultDownloadHelper;
        defaultDownloadDBController.dbHelper = new DefaultDownloadHelper(context, config);
        defaultDownloadDBController.writableDatabase = object.getWritableDatabase();
        defaultDownloadDBController.readableDatabase = object.getReadableDatabase();
    }

    private void inflateDownloadThreadInfo(Cursor cursor, DownloadThreadInfo downloadThreadInfo) {
        downloadThreadInfo.setId(cursor.getInt(0));
        downloadThreadInfo.setThreadId(cursor.getInt(1));
        downloadThreadInfo.setDownloadInfoId(cursor.getInt(2));
        downloadThreadInfo.setUri(cursor.getString(3));
        downloadThreadInfo.setStart(cursor.getLong(4));
        downloadThreadInfo.setEnd(cursor.getLong(5));
        downloadThreadInfo.setProgress(cursor.getLong(6));
    }

    private void inflateDownloadInfo(Cursor cursor, DownloadInfo downloadInfo) {
        downloadInfo.setId(cursor.getInt(0));
        downloadInfo.setSupportRanges(cursor.getInt(1));
        downloadInfo.setCreateAt(cursor.getLong(2));
        downloadInfo.setUri(cursor.getString(3));
        downloadInfo.setLocation(cursor.getString(4));
        downloadInfo.setPath(cursor.getString(5));
        downloadInfo.setSize(cursor.getLong(6));
        downloadInfo.setProgress(cursor.getLong(7));
        downloadInfo.setStatus(cursor.getInt(8));
    }

    static {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "download_thread_info";
        SQL_UPDATE_DOWNLOAD_THREAD_INFO = String.format("REPLACE INTO %s (_id,threadId,downloadInfoId,uri,start,end,progress) VALUES(?,?,?,?,?,?,?);", objectArray2);
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = "download_info";
        SQL_UPDATE_DOWNLOAD_INFO = String.format("REPLACE INTO %s (_id,supportRanges,createAt,uri,location,path,size,progress,status) VALUES(?,?,?,?,?,?,?,?,?);", objectArray2);
        Object[] objectArray4 = new Object[1];
        objectArray2 = objectArray4;
        objectArray4[0] = "download_info";
        SQL_UPDATE_DOWNLOADING_INFO_STATUS = String.format("UPDATE %s SET status=? WHERE status!=?;", objectArray2);
    }

    @Override
    public List<DownloadInfo> findAllDownloading() {
        ArrayList<DownloadInfo> arrayList;
        Cursor cursor = new String[1];
        Cursor cursor2 = cursor;
        cursor[0] = String.valueOf(5);
        cursor2 = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "status!=?", (String[])cursor2, null, null, "createAt desc");
        ArrayList<DownloadInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<DownloadInfo>();
        while (cursor2.moveToNext()) {
            ArrayList<DownloadThreadInfo> arrayList3;
            DownloadInfo downloadInfo;
            DefaultDownloadDBController defaultDownloadDBController = this;
            DownloadInfo downloadInfo2 = downloadInfo;
            arrayList2.add(new DownloadInfo(this.context));
            defaultDownloadDBController.inflateDownloadInfo(cursor2, downloadInfo2);
            Cursor cursor3 = new String[1];
            Cursor cursor4 = cursor3;
            cursor3[0] = String.valueOf(downloadInfo2.getId());
            cursor4 = defaultDownloadDBController.readableDatabase.query("download_thread_info", DOWNLOAD_THREAD_INFO_COLUMNS, "downloadInfoId=?", (String[])cursor4, null, null, null);
            ArrayList<DownloadThreadInfo> arrayList4 = arrayList3;
            arrayList3 = new ArrayList<DownloadThreadInfo>();
            while (cursor4.moveToNext()) {
                DownloadThreadInfo downloadThreadInfo;
                DownloadThreadInfo downloadThreadInfo2 = downloadThreadInfo;
                downloadThreadInfo = new DownloadThreadInfo();
                arrayList4.add(downloadThreadInfo2);
                this.inflateDownloadThreadInfo(cursor4, downloadThreadInfo2);
            }
            downloadInfo2.setDownloadThreadInfos(arrayList4);
        }
        return arrayList2;
    }

    @Override
    public List<DownloadInfo> findAllDownloaded() {
        ArrayList<DownloadInfo> arrayList;
        Cursor cursor = new String[1];
        Cursor cursor2 = cursor;
        cursor[0] = String.valueOf(5);
        cursor2 = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "status=?", (String[])cursor2, null, null, "createAt desc");
        ArrayList<DownloadInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<DownloadInfo>();
        while (cursor2.moveToNext()) {
            DownloadInfo downloadInfo;
            DownloadInfo downloadInfo2 = downloadInfo;
            arrayList2.add(new DownloadInfo(this.context));
            this.inflateDownloadInfo(cursor2, downloadInfo2);
        }
        return arrayList2;
    }

    @Override
    public DownloadInfo findDownloadedInfoById(int n2) {
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = String.valueOf(n2);
        Cursor cursor = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "_id=?", object, null, null, "createAt desc");
        if (cursor.moveToNext()) {
            DownloadInfo downloadInfo;
            object = downloadInfo;
            object(this.context);
            this.inflateDownloadInfo(cursor, (DownloadInfo)object);
            return downloadInfo;
        }
        return null;
    }

    @Override
    public void pauseAllDownloading() {
        this.writableDatabase.execSQL(SQL_UPDATE_DOWNLOADING_INFO_STATUS, new Object[]{4, 5});
    }

    @Override
    public void createOrUpdate(DownloadInfo downloadInfo) {
        Object[] objectArray = new Object[9];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = downloadInfo.getId();
        objectArray2[1] = downloadInfo.getSupportRanges();
        objectArray2[2] = downloadInfo.getCreateAt();
        objectArray2[3] = downloadInfo.getUri();
        objectArray2[4] = downloadInfo.getLocation();
        objectArray2[5] = downloadInfo.getPath();
        objectArray2[6] = downloadInfo.getSize();
        objectArray2[7] = downloadInfo.getProgress();
        objectArray[8] = downloadInfo.getStatus();
        objectArray2.writableDatabase.execSQL(SQL_UPDATE_DOWNLOAD_INFO, objectArray);
    }

    @Override
    public void createOrUpdate(DownloadThreadInfo downloadThreadInfo) {
        Object[] objectArray = new Object[7];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = downloadThreadInfo.getId();
        objectArray2[1] = downloadThreadInfo.getThreadId();
        objectArray2[2] = downloadThreadInfo.getDownloadInfoId();
        objectArray2[3] = downloadThreadInfo.getUri();
        objectArray2[4] = downloadThreadInfo.getStart();
        objectArray2[5] = downloadThreadInfo.getEnd();
        objectArray[6] = downloadThreadInfo.getProgress();
        objectArray2.writableDatabase.execSQL(SQL_UPDATE_DOWNLOAD_THREAD_INFO, objectArray);
    }

    @Override
    public void delete(DownloadInfo downloadInfo) {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(downloadInfo.getId());
        stringArray2.writableDatabase.delete("download_info", "_id=?", stringArray2);
        String[] stringArray3 = new String[1];
        stringArray2 = stringArray3;
        stringArray3[0] = String.valueOf(downloadInfo.getId());
        stringArray2.writableDatabase.delete("download_thread_info", "downloadInfoId=?", stringArray2);
    }

    @Override
    public void delete(DownloadThreadInfo downloadThreadInfo) {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(downloadThreadInfo.getId());
        stringArray2.writableDatabase.delete("download_thread_info", "id=?", stringArray2);
    }
}

