/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.format;

import android.media.MediaFormat;
import androidtranscoder.format.MediaFormatStrategy;

class Android720pFormatStrategy
implements MediaFormatStrategy {
    public static final int AUDIO_BITRATE_AS_IS = -1;
    public static final int AUDIO_CHANNELS_AS_IS = -1;
    private static final String TAG = "720pFormatStrategy";
    private static final int LONGER_LENGTH = 1280;
    private static final int SHORTER_LENGTH = 720;
    private static final int DEFAULT_VIDEO_BITRATE = 8000000;
    private int mVideoBitrate;
    private final int mAudioBitrate;
    private final int mAudioChannels;
    private int compressLevel = 1;

    public Android720pFormatStrategy() {
        this(1);
    }

    public Android720pFormatStrategy(int n2) {
        this.mAudioBitrate = 128000;
        this.mAudioChannels = 1;
        this.compressLevel = n2;
    }

    @Override
    public MediaFormat createVideoOutputFormat(MediaFormat mediaFormat) {
        MediaFormat mediaFormat2 = mediaFormat;
        int n2 = mediaFormat2.getInteger("width");
        int n3 = mediaFormat2.getInteger("height");
        int n4 = this.compressLevel;
        if (n4 == 1) {
            n2 = (int)((double)n2 * 0.9);
            n3 = (int)((double)n3 * 0.9);
        } else if (n4 == 2) {
            n2 = (int)((double)n2 * 0.8);
            n3 = (int)((double)n3 * 0.8);
        } else {
            n2 = (int)((double)n2 * 0.5);
            n3 = (int)((double)n3 * 0.5);
        }
        this.mVideoBitrate = n2 * n3;
        MediaFormat mediaFormat3 = MediaFormat.createVideoFormat((String)"video/avc", (int)n2, (int)n3);
        mediaFormat3.setInteger("bitrate", this.mVideoBitrate);
        mediaFormat3.setInteger("frame-rate", 25);
        mediaFormat3.setInteger("i-frame-interval", 3);
        mediaFormat3.setInteger("color-format", 2130708361);
        return mediaFormat3;
    }

    @Override
    public MediaFormat createAudioOutputFormat(MediaFormat mediaFormat) {
        if (this.mAudioBitrate != -1 && this.mAudioChannels != -1) {
            int n2 = mediaFormat.getInteger("sample-rate");
            int n3 = this.mAudioChannels;
            MediaFormat mediaFormat2 = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)n3);
            mediaFormat2.setInteger("aac-profile", 2);
            mediaFormat2.setInteger("bitrate", this.mAudioBitrate);
            return mediaFormat2;
        }
        return null;
    }
}

