/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.engine;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

class TextureRender {
    private static final String TAG = "TextureRender";
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private final float[] mTriangleVerticesData;
    private FloatBuffer mTriangleVertices;
    private float[] mMVPMatrix;
    private float[] mSTMatrix;
    private int mProgram;
    private int mTextureID;
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;
    private int maPositionHandle;
    private int maTextureHandle;

    public TextureRender() {
        FloatBuffer floatBuffer;
        TextureRender textureRender = this;
        float[] fArray = new float[20];
        float[] fArray2 = fArray;
        fArray[0] = -1.0f;
        fArray[1] = -1.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = -1.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        fArray[9] = 0.0f;
        fArray[10] = -1.0f;
        fArray[11] = 1.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 1.0f;
        fArray[15] = 1.0f;
        fArray[16] = 1.0f;
        fArray[17] = 0.0f;
        fArray[18] = 1.0f;
        fArray[19] = 1.0f;
        textureRender.mTriangleVerticesData = fArray;
        textureRender.mMVPMatrix = new float[16];
        textureRender.mSTMatrix = new float[16];
        textureRender.mTextureID = -12345;
        this.mTriangleVertices = floatBuffer = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray2).position(0);
        Matrix.setIdentityM((float[])textureRender.mSTMatrix, (int)0);
    }

    private int loadShader(int n2, String string2) {
        int n3 = GLES20.glCreateShader((int)n2);
        ((TextureRender)object).checkGlError("glCreateShader type=" + n2);
        GLES20.glShaderSource((int)n3, (String)string2);
        GLES20.glCompileShader((int)n3);
        int[] nArray = new int[1];
        Object object = nArray;
        GLES20.glGetShaderiv((int)n3, (int)35713, (int[])object, (int)0);
        if (nArray[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader " + n2 + ":"));
            Log.e((String)TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)n3)));
            GLES20.glDeleteShader((int)n3);
            n3 = 0;
        }
        return n3;
    }

    private int createProgram(String string2, String string3) {
        int n2 = ((TextureRender)object).loadShader(35633, string2);
        if (n2 == 0) {
            return 0;
        }
        int n3 = ((TextureRender)object).loadShader(35632, string3);
        if (n3 == 0) {
            return 0;
        }
        int n4 = GLES20.glCreateProgram();
        ((TextureRender)object).checkGlError("glCreateProgram");
        if (n4 == 0) {
            Log.e((String)TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)n4, (int)n2);
        ((TextureRender)object).checkGlError("glAttachShader");
        GLES20.glAttachShader((int)n4, (int)n3);
        ((TextureRender)object).checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)n4);
        int[] nArray = new int[1];
        Object object = nArray;
        GLES20.glGetProgramiv((int)n4, (int)35714, (int[])object, (int)0);
        if (nArray[0] != 1) {
            int n5 = n4;
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)n5));
            GLES20.glDeleteProgram((int)n5);
            n4 = 0;
        }
        return n4;
    }

    public static void saveFrame(String string2, int n2, int n3) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int getTextureId() {
        return this.mTextureID;
    }

    public void drawFrame(SurfaceTexture object) {
        TextureRender textureRender = object2;
        TextureRender textureRender2 = object2;
        textureRender2.checkGlError("onDrawFrame start");
        object.getTransformMatrix(textureRender2.mSTMatrix);
        GLES20.glClearColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)textureRender.mProgram);
        textureRender.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)textureRender.mTextureID);
        textureRender.mTriangleVertices.position(0);
        object = ((TextureRender)object2).mTriangleVertices;
        GLES20.glVertexAttribPointer((int)textureRender.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)object);
        textureRender.checkGlError("glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray((int)textureRender.maPositionHandle);
        textureRender.checkGlError("glEnableVertexAttribArray maPositionHandle");
        textureRender.mTriangleVertices.position(3);
        object = ((TextureRender)object2).mTriangleVertices;
        GLES20.glVertexAttribPointer((int)textureRender.maTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)object);
        textureRender.checkGlError("glVertexAttribPointer maTextureHandle");
        GLES20.glEnableVertexAttribArray((int)textureRender.maTextureHandle);
        textureRender.checkGlError("glEnableVertexAttribArray maTextureHandle");
        Matrix.setIdentityM((float[])textureRender.mMVPMatrix, (int)0);
        object = ((TextureRender)object2).mMVPMatrix;
        GLES20.glUniformMatrix4fv((int)textureRender.muMVPMatrixHandle, (int)1, (boolean)false, (float[])object, (int)0);
        Object object2 = ((TextureRender)object2).mSTMatrix;
        GLES20.glUniformMatrix4fv((int)textureRender.muSTMatrixHandle, (int)1, (boolean)false, (float[])object2, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        textureRender.checkGlError("glDrawArrays");
        GLES20.glFinish();
    }

    public void surfaceCreated() {
        int n2;
        this.mProgram = n2 = this.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
        if (n2 != 0) {
            TextureRender textureRender = this;
            textureRender.maPositionHandle = GLES20.glGetAttribLocation((int)n2, (String)"aPosition");
            textureRender.checkGlError("glGetAttribLocation aPosition");
            if (textureRender.maPositionHandle != -1) {
                TextureRender textureRender2 = this;
                textureRender2.maTextureHandle = GLES20.glGetAttribLocation((int)textureRender2.mProgram, (String)"aTextureCoord");
                textureRender2.checkGlError("glGetAttribLocation aTextureCoord");
                if (textureRender2.maTextureHandle != -1) {
                    TextureRender textureRender3 = this;
                    textureRender3.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)textureRender3.mProgram, (String)"uMVPMatrix");
                    textureRender3.checkGlError("glGetUniformLocation uMVPMatrix");
                    if (textureRender3.muMVPMatrixHandle != -1) {
                        TextureRender textureRender4 = this;
                        textureRender4.muSTMatrixHandle = GLES20.glGetUniformLocation((int)textureRender4.mProgram, (String)"uSTMatrix");
                        textureRender4.checkGlError("glGetUniformLocation uSTMatrix");
                        if (textureRender4.muSTMatrixHandle != -1) {
                            int n3;
                            TextureRender textureRender5 = this;
                            int[] nArray = new int[1];
                            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
                            textureRender5.mTextureID = n3 = nArray[0];
                            GLES20.glBindTexture((int)36197, (int)n3);
                            textureRender5.checkGlError("glBindTexture mTextureID");
                            GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
                            GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
                            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
                            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
                            textureRender5.checkGlError("glTexParameter");
                            return;
                        }
                        throw new RuntimeException("Could not get attrib location for uSTMatrix");
                    }
                    throw new RuntimeException("Could not get attrib location for uMVPMatrix");
                }
                throw new RuntimeException("Could not get attrib location for aTextureCoord");
            }
            throw new RuntimeException("Could not get attrib location for aPosition");
        }
        throw new RuntimeException("failed creating program");
    }

    public void changeFragmentShader(String string2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void checkGlError(String string2) {
        int n2 = GLES20.glGetError();
        if (n2 == 0) {
            return;
        }
        Log.e((String)TAG, (String)(string2 + ": glError " + n2));
        throw new RuntimeException(string2 + ": glError " + n2);
    }
}

