/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import com.lidroid.xutils.bitmap.BitmapCacheListener;
import com.lidroid.xutils.bitmap.BitmapCommonUtils;
import com.lidroid.xutils.bitmap.BitmapDisplayConfig;
import com.lidroid.xutils.bitmap.BitmapGlobalConfig;
import com.lidroid.xutils.bitmap.callback.BitmapLoadCallBack;
import com.lidroid.xutils.bitmap.callback.BitmapLoadFrom;
import com.lidroid.xutils.bitmap.callback.DefaultBitmapLoadCallBack;
import com.lidroid.xutils.bitmap.core.AsyncDrawable;
import com.lidroid.xutils.bitmap.core.BitmapSize;
import com.lidroid.xutils.bitmap.download.Downloader;
import com.lidroid.xutils.cache.FileNameGenerator;
import com.lidroid.xutils.task.PriorityAsyncTask;
import com.lidroid.xutils.task.PriorityExecutor;
import com.lidroid.xutils.task.TaskHandler;
import java.io.File;
import java.lang.ref.WeakReference;

public class BitmapUtils
implements TaskHandler {
    private boolean pauseTask = false;
    private boolean cancelAllTask = false;
    private final Object pauseTaskLock = new Object();
    private Context context;
    private BitmapGlobalConfig globalConfig;
    private BitmapDisplayConfig defaultDisplayConfig;

    public BitmapUtils(Context context) {
        this(context, null);
    }

    public BitmapUtils(Context context, String diskCachePath) {
        if (context == null) {
            throw new IllegalArgumentException("context may not be null");
        }
        this.context = context.getApplicationContext();
        this.globalConfig = BitmapGlobalConfig.getInstance(this.context, diskCachePath);
        this.defaultDisplayConfig = new BitmapDisplayConfig();
    }

    public BitmapUtils(Context context, String diskCachePath, int memoryCacheSize) {
        this(context, diskCachePath);
        this.globalConfig.setMemoryCacheSize(memoryCacheSize);
    }

    public BitmapUtils(Context context, String diskCachePath, int memoryCacheSize, int diskCacheSize) {
        this(context, diskCachePath);
        this.globalConfig.setMemoryCacheSize(memoryCacheSize);
        this.globalConfig.setDiskCacheSize(diskCacheSize);
    }

    public BitmapUtils(Context context, String diskCachePath, float memoryCachePercent) {
        this(context, diskCachePath);
        this.globalConfig.setMemCacheSizePercent(memoryCachePercent);
    }

    public BitmapUtils(Context context, String diskCachePath, float memoryCachePercent, int diskCacheSize) {
        this(context, diskCachePath);
        this.globalConfig.setMemCacheSizePercent(memoryCachePercent);
        this.globalConfig.setDiskCacheSize(diskCacheSize);
    }

    public BitmapUtils configDefaultLoadingImage(Drawable drawable) {
        this.defaultDisplayConfig.setLoadingDrawable(drawable);
        return this;
    }

    public BitmapUtils configDefaultLoadingImage(int resId) {
        this.defaultDisplayConfig.setLoadingDrawable(this.context.getResources().getDrawable(resId));
        return this;
    }

    public BitmapUtils configDefaultLoadingImage(Bitmap bitmap) {
        this.defaultDisplayConfig.setLoadingDrawable((Drawable)new BitmapDrawable(this.context.getResources(), bitmap));
        return this;
    }

    public BitmapUtils configDefaultLoadFailedImage(Drawable drawable) {
        this.defaultDisplayConfig.setLoadFailedDrawable(drawable);
        return this;
    }

    public BitmapUtils configDefaultLoadFailedImage(int resId) {
        this.defaultDisplayConfig.setLoadFailedDrawable(this.context.getResources().getDrawable(resId));
        return this;
    }

    public BitmapUtils configDefaultLoadFailedImage(Bitmap bitmap) {
        this.defaultDisplayConfig.setLoadFailedDrawable((Drawable)new BitmapDrawable(this.context.getResources(), bitmap));
        return this;
    }

    public BitmapUtils configDefaultBitmapMaxSize(int maxWidth, int maxHeight) {
        this.defaultDisplayConfig.setBitmapMaxSize(new BitmapSize(maxWidth, maxHeight));
        return this;
    }

    public BitmapUtils configDefaultBitmapMaxSize(BitmapSize maxSize) {
        this.defaultDisplayConfig.setBitmapMaxSize(maxSize);
        return this;
    }

    public BitmapUtils configDefaultImageLoadAnimation(Animation animation) {
        this.defaultDisplayConfig.setAnimation(animation);
        return this;
    }

    public BitmapUtils configDefaultAutoRotation(boolean autoRotation) {
        this.defaultDisplayConfig.setAutoRotation(autoRotation);
        return this;
    }

    public BitmapUtils configDefaultShowOriginal(boolean showOriginal) {
        this.defaultDisplayConfig.setShowOriginal(showOriginal);
        return this;
    }

    public BitmapUtils configDefaultBitmapConfig(Bitmap.Config config) {
        this.defaultDisplayConfig.setBitmapConfig(config);
        return this;
    }

    public BitmapUtils configDefaultDisplayConfig(BitmapDisplayConfig displayConfig) {
        this.defaultDisplayConfig = displayConfig;
        return this;
    }

    public BitmapUtils configDownloader(Downloader downloader) {
        this.globalConfig.setDownloader(downloader);
        return this;
    }

    public BitmapUtils configDefaultCacheExpiry(long defaultExpiry) {
        this.globalConfig.setDefaultCacheExpiry(defaultExpiry);
        return this;
    }

    public BitmapUtils configDefaultConnectTimeout(int connectTimeout) {
        this.globalConfig.setDefaultConnectTimeout(connectTimeout);
        return this;
    }

    public BitmapUtils configDefaultReadTimeout(int readTimeout) {
        this.globalConfig.setDefaultReadTimeout(readTimeout);
        return this;
    }

    public BitmapUtils configThreadPoolSize(int threadPoolSize) {
        this.globalConfig.setThreadPoolSize(threadPoolSize);
        return this;
    }

    public BitmapUtils configMemoryCacheEnabled(boolean enabled) {
        this.globalConfig.setMemoryCacheEnabled(enabled);
        return this;
    }

    public BitmapUtils configDiskCacheEnabled(boolean enabled) {
        this.globalConfig.setDiskCacheEnabled(enabled);
        return this;
    }

    public BitmapUtils configDiskCacheFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.globalConfig.setFileNameGenerator(fileNameGenerator);
        return this;
    }

    public BitmapUtils configBitmapCacheListener(BitmapCacheListener listener) {
        this.globalConfig.setBitmapCacheListener(listener);
        return this;
    }

    public <T extends View> void display(T container, String uri) {
        this.display(container, uri, null, null);
    }

    public <T extends View> void display(T container, String uri, BitmapDisplayConfig displayConfig) {
        this.display(container, uri, displayConfig, null);
    }

    public <T extends View> void display(T container, String uri, BitmapLoadCallBack<T> callBack) {
        this.display(container, uri, null, callBack);
    }

    public <T extends View> void display(T container, String uri, BitmapDisplayConfig displayConfig, BitmapLoadCallBack<T> callBack) {
        if (container == null) {
            return;
        }
        if (callBack == null) {
            callBack = new DefaultBitmapLoadCallBack();
        }
        if (displayConfig == null || displayConfig == this.defaultDisplayConfig) {
            displayConfig = this.defaultDisplayConfig.cloneNew();
        }
        BitmapSize size = displayConfig.getBitmapMaxSize();
        displayConfig.setBitmapMaxSize(BitmapCommonUtils.optimizeMaxSizeByView(container, size.getWidth(), size.getHeight()));
        container.clearAnimation();
        if (TextUtils.isEmpty((CharSequence)uri)) {
            callBack.onLoadFailed(container, uri, displayConfig.getLoadFailedDrawable());
            return;
        }
        callBack.onPreLoad(container, uri, displayConfig);
        Bitmap bitmap = this.globalConfig.getBitmapCache().getBitmapFromMemCache(uri, displayConfig);
        if (bitmap != null) {
            callBack.onLoadStarted(container, uri, displayConfig);
            callBack.onLoadCompleted(container, uri, bitmap, displayConfig, BitmapLoadFrom.MEMORY_CACHE);
        } else if (!BitmapUtils.bitmapLoadTaskExist(container, uri, callBack)) {
            boolean diskCacheExist;
            BitmapLoadTask loadTask = new BitmapLoadTask(this, container, uri, displayConfig, callBack);
            PriorityExecutor executor = this.globalConfig.getBitmapLoadExecutor();
            File diskCacheFile = this.getBitmapFileFromDiskCache(uri);
            boolean bl = diskCacheExist = diskCacheFile != null && diskCacheFile.exists();
            if (diskCacheExist && executor.isBusy()) {
                executor = this.globalConfig.getDiskCacheExecutor();
            }
            Drawable loadingDrawable = displayConfig.getLoadingDrawable();
            callBack.setDrawable(container, new AsyncDrawable(loadingDrawable, loadTask));
            loadTask.setPriority(displayConfig.getPriority());
            loadTask.executeOnExecutor(executor, new Object[0]);
        }
    }

    public void clearCache() {
        this.globalConfig.clearCache();
    }

    public void clearMemoryCache() {
        this.globalConfig.clearMemoryCache();
    }

    public void clearDiskCache() {
        this.globalConfig.clearDiskCache();
    }

    public void clearCache(String uri) {
        this.globalConfig.clearCache(uri);
    }

    public void clearMemoryCache(String uri) {
        this.globalConfig.clearMemoryCache(uri);
    }

    public void clearDiskCache(String uri) {
        this.globalConfig.clearDiskCache(uri);
    }

    public void flushCache() {
        this.globalConfig.flushCache();
    }

    public void closeCache() {
        this.globalConfig.closeCache();
    }

    public File getBitmapFileFromDiskCache(String uri) {
        return this.globalConfig.getBitmapCache().getBitmapFileFromDiskCache(uri);
    }

    public Bitmap getBitmapFromMemCache(String uri, BitmapDisplayConfig config) {
        if (config == null) {
            config = this.defaultDisplayConfig;
        }
        return this.globalConfig.getBitmapCache().getBitmapFromMemCache(uri, config);
    }

    @Override
    public boolean supportPause() {
        return true;
    }

    @Override
    public boolean supportResume() {
        return true;
    }

    @Override
    public boolean supportCancel() {
        return true;
    }

    @Override
    public void pause() {
        this.pauseTask = true;
        this.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.pauseTask = false;
        Object object = this.pauseTaskLock;
        synchronized (object) {
            this.pauseTaskLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.pauseTask = true;
        this.cancelAllTask = true;
        Object object = this.pauseTaskLock;
        synchronized (object) {
            this.pauseTaskLock.notifyAll();
        }
    }

    @Override
    public boolean isPaused() {
        return this.pauseTask;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelAllTask;
    }

    private static <T extends View> BitmapLoadTask<T> getBitmapTaskFromContainer(T container, BitmapLoadCallBack<T> callBack) {
        Drawable drawable;
        if (container != null && (drawable = callBack.getDrawable(container)) instanceof AsyncDrawable) {
            AsyncDrawable asyncDrawable = (AsyncDrawable)drawable;
            return asyncDrawable.getBitmapWorkerTask();
        }
        return null;
    }

    private static <T extends View> boolean bitmapLoadTaskExist(T container, String uri, BitmapLoadCallBack<T> callBack) {
        BitmapLoadTask<T> oldLoadTask = BitmapUtils.getBitmapTaskFromContainer(container, callBack);
        if (oldLoadTask != null) {
            String oldUrl = ((BitmapLoadTask)oldLoadTask).uri;
            if (TextUtils.isEmpty((CharSequence)oldUrl) || !oldUrl.equals(uri)) {
                oldLoadTask.cancel(true);
            } else {
                return true;
            }
        }
        return false;
    }

    public static class BitmapLoadTask<T extends View>
    extends PriorityAsyncTask<Object, Object, Bitmap> {
        private final String uri;
        private final WeakReference<T> containerReference;
        private final BitmapLoadCallBack<T> callBack;
        private final BitmapDisplayConfig displayConfig;
        private BitmapLoadFrom from = BitmapLoadFrom.DISK_CACHE;
        private static final int PROGRESS_LOAD_STARTED = 0;
        private static final int PROGRESS_LOADING = 1;
        final /* synthetic */ BitmapUtils this$0;

        public BitmapLoadTask(T container, String uri, BitmapDisplayConfig config, BitmapLoadCallBack<T> callBack) {
            this.this$0 = var1_1;
            if (container == null || uri == null || config == null || callBack == null) {
                throw new IllegalArgumentException("args may not be null");
            }
            this.containerReference = new WeakReference<T>(container);
            this.callBack = callBack;
            this.uri = uri;
            this.displayConfig = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Bitmap doInBackground(Object ... params) {
            Object object = this.this$0.pauseTaskLock;
            synchronized (object) {
                while (this.this$0.pauseTask && !this.isCancelled()) {
                    try {
                        this.this$0.pauseTaskLock.wait();
                        if (!this.this$0.cancelAllTask) continue;
                        return null;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                        continue;
                    }
                    break;
                }
            }
            Bitmap bitmap = null;
            if (!this.isCancelled() && this.getTargetContainer() != null) {
                this.publishProgress(0);
                bitmap = this.this$0.globalConfig.getBitmapCache().getBitmapFromDiskCache(this.uri, this.displayConfig);
            }
            if (bitmap == null && !this.isCancelled() && this.getTargetContainer() != null) {
                bitmap = this.this$0.globalConfig.getBitmapCache().downloadBitmap(this.uri, this.displayConfig, this);
                this.from = BitmapLoadFrom.URI;
            }
            return bitmap;
        }

        public void updateProgress(long total, long current) {
            this.publishProgress(1, total, current);
        }

        @Override
        protected void onProgressUpdate(Object ... values) {
            if (values == null || values.length == 0) {
                return;
            }
            T container = this.getTargetContainer();
            if (container == null) {
                return;
            }
            switch ((Integer)values[0]) {
                case 0: {
                    this.callBack.onLoadStarted(container, this.uri, this.displayConfig);
                    break;
                }
                case 1: {
                    if (values.length != 3) {
                        return;
                    }
                    this.callBack.onLoading(container, this.uri, this.displayConfig, (Long)values[1], (Long)values[2]);
                    break;
                }
            }
        }

        @Override
        protected void onPostExecute(Bitmap bitmap) {
            T container = this.getTargetContainer();
            if (container != null) {
                if (bitmap != null) {
                    this.callBack.onLoadCompleted(container, this.uri, bitmap, this.displayConfig, this.from);
                } else {
                    this.callBack.onLoadFailed(container, this.uri, this.displayConfig.getLoadFailedDrawable());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCancelled(Bitmap bitmap) {
            Object object = this.this$0.pauseTaskLock;
            synchronized (object) {
                this.this$0.pauseTaskLock.notifyAll();
            }
        }

        public T getTargetContainer() {
            View container = (View)this.containerReference.get();
            BitmapLoadTask bitmapWorkerTask = BitmapUtils.getBitmapTaskFromContainer(container, this.callBack);
            if (this == bitmapWorkerTask) {
                return (T)container;
            }
            return null;
        }
    }
}

