/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.naming.controllers.OperatorController;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="consoleHealth")
@RequestMapping(value={"/v1/console/health"})
public class HealthController {
    private static final Logger logger = LoggerFactory.getLogger(HealthController.class);
    private final PersistService persistService;
    private final OperatorController apiCommands;

    @Autowired
    public HealthController(PersistService persistService, OperatorController apiCommands) {
        this.persistService = persistService;
        this.apiCommands = apiCommands;
    }

    @GetMapping(value={"/liveness"})
    public ResponseEntity liveness() {
        return ResponseEntity.ok().body((Object)"OK");
    }

    @GetMapping(value={"/readiness"})
    public ResponseEntity readiness(HttpServletRequest request) {
        boolean isConfigReadiness = this.isConfigReadiness();
        boolean isNamingReadiness = this.isNamingReadiness(request);
        if (isConfigReadiness && isNamingReadiness) {
            return ResponseEntity.ok().body((Object)"OK");
        }
        if (!isConfigReadiness && !isNamingReadiness) {
            return ResponseEntity.status((int)500).body((Object)"Config and Naming are not in readiness");
        }
        if (!isConfigReadiness) {
            return ResponseEntity.status((int)500).body((Object)"Config is not in readiness");
        }
        return ResponseEntity.status((int)500).body((Object)"Naming is not in readiness");
    }

    private boolean isConfigReadiness() {
        try {
            this.persistService.configInfoCount("");
            return true;
        }
        catch (Exception e) {
            logger.error("Config health check fail.", (Throwable)e);
            return false;
        }
    }

    private boolean isNamingReadiness(HttpServletRequest request) {
        try {
            this.apiCommands.metrics(request);
            return true;
        }
        catch (Exception e) {
            logger.error("Naming health check fail.", (Throwable)e);
            return false;
        }
    }
}

