/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtils {
    private final Logger log = LoggerFactory.getLogger(JwtTokenUtils.class);
    private static final String AUTHORITIES_KEY = "auth";
    private static final int SHA_256_SECRET_CHAR_SIZE = 32;
    private static final String DEFAULT_SECRET_FLAG = "default";
    @Value(value="${nacos.security.token.secret-key:default}")
    private String customSecretKeyStr;
    private SecretKey secretKey;
    private long tokenValidityInMilliseconds;

    @PostConstruct
    public void init() {
        if (this.customSecretKeyStr == null || DEFAULT_SECRET_FLAG.equals(this.customSecretKeyStr)) {
            this.secretKey = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
        } else {
            int size = this.customSecretKeyStr.length();
            int left = 32 - size;
            if (left > 0) {
                StringBuilder stringBuilder = new StringBuilder(this.customSecretKeyStr);
                for (int i = 0; i < left; ++i) {
                    stringBuilder.append(i % 10);
                }
                this.secretKey = Keys.hmacShaKeyFor((byte[])stringBuilder.toString().getBytes());
            } else {
                this.secretKey = Keys.hmacShaKeyFor((byte[])this.customSecretKeyStr.getBytes());
            }
        }
        this.tokenValidityInMilliseconds = 1800000L;
    }

    public String createToken(Authentication authentication) {
        long now = new Date().getTime();
        Date validity = new Date(now + this.tokenValidityInMilliseconds);
        return Jwts.builder().setSubject(authentication.getName()).claim(AUTHORITIES_KEY, (Object)"").setExpiration(validity).signWith((Key)this.secretKey, SignatureAlgorithm.HS256).compact();
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey((Key)this.secretKey).parseClaimsJws(token).getBody();
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)claims.get((Object)AUTHORITIES_KEY)));
        User principal = new User(claims.getSubject(), "", (Collection)authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", (Collection)authorities);
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parser().setSigningKey((Key)this.secretKey).parseClaimsJws(token);
            return true;
        }
        catch (SignatureException e) {
            this.log.info("Invalid JWT signature.");
            this.log.trace("Invalid JWT signature trace: {}", (Throwable)e);
        }
        catch (MalformedJwtException e) {
            this.log.info("Invalid JWT token.");
            this.log.trace("Invalid JWT token trace: {}", (Throwable)e);
        }
        catch (ExpiredJwtException e) {
            this.log.info("Expired JWT token.");
            this.log.trace("Expired JWT token trace: {}", (Throwable)e);
        }
        catch (UnsupportedJwtException e) {
            this.log.info("Unsupported JWT token.");
            this.log.trace("Unsupported JWT token trace: {}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.log.info("JWT token compact of handler are invalid.");
            this.log.trace("JWT token compact of handler are invalid trace: {}", (Throwable)e);
        }
        return false;
    }
}

