/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.config.server.model.RestResult;
import com.alibaba.nacos.config.server.model.TenantInfo;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.console.model.Namespace;
import com.alibaba.nacos.console.model.NamespaceAllInfo;
import com.alibaba.nacos.core.auth.ActionTypes;
import com.alibaba.nacos.core.auth.Secured;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/console/namespaces"})
public class NamespaceController {
    @Autowired
    private PersistService persistService;
    private Pattern namespaceIdCheckPattern = Pattern.compile("^[\\w-]+");
    private static final int NAMESPACE_ID_MAX_LENGTH = 128;

    @GetMapping
    public RestResult<List<Namespace>> getNamespaces(HttpServletRequest request, HttpServletResponse response) {
        RestResult rr = new RestResult();
        rr.setCode(200);
        List tenantInfos = this.persistService.findTenantByKp("1");
        Namespace namespace0 = new Namespace("", "public", 200, this.persistService.configInfoCount(""), 0);
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        namespaces.add(namespace0);
        for (TenantInfo tenantInfo : tenantInfos) {
            int configCount = this.persistService.configInfoCount(tenantInfo.getTenantId());
            Namespace namespaceTmp = new Namespace(tenantInfo.getTenantId(), tenantInfo.getTenantName(), 200, configCount, 2);
            namespaces.add(namespaceTmp);
        }
        rr.setData(namespaces);
        return rr;
    }

    @GetMapping(params={"show=all"})
    public NamespaceAllInfo getNamespace(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="namespaceId") String namespaceId) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            return new NamespaceAllInfo(namespaceId, "Public", 200, this.persistService.configInfoCount(""), 0, "Public Namespace");
        }
        TenantInfo tenantInfo = this.persistService.findTenantByKp("1", namespaceId);
        int configCount = this.persistService.configInfoCount(namespaceId);
        return new NamespaceAllInfo(namespaceId, tenantInfo.getTenantName(), 200, configCount, 2, tenantInfo.getTenantDesc());
    }

    @PostMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean createNamespace(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="customNamespaceId") String namespaceId, @RequestParam(value="namespaceName") String namespaceName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = UUID.randomUUID().toString();
        } else {
            if (!this.namespaceIdCheckPattern.matcher(namespaceId = namespaceId.trim()).matches()) {
                return false;
            }
            if (namespaceId.length() > 128) {
                return false;
            }
            if (this.persistService.tenantInfoCountByTenantId(namespaceId) > 0) {
                return false;
            }
        }
        this.persistService.insertTenantInfoAtomic("1", namespaceId, namespaceName, namespaceDesc, "nacos", System.currentTimeMillis());
        return true;
    }

    @GetMapping(params={"checkNamespaceIdExist=true"})
    public Boolean checkNamespaceIdExist(@RequestParam(value="customNamespaceId") String namespaceId) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            return false;
        }
        return this.persistService.tenantInfoCountByTenantId(namespaceId) > 0;
    }

    @PutMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean editNamespace(@RequestParam(value="namespace") String namespace, @RequestParam(value="namespaceShowName") String namespaceShowName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        this.persistService.updateTenantNameAtomic("1", namespace, namespaceShowName, namespaceDesc);
        return true;
    }

    @DeleteMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="namespaceId") String namespaceId) {
        this.persistService.removeTenantInfoAtomic("1", namespaceId);
        return true;
    }
}

